/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_TAU_LLDriver.h                                                                                  */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains Global variable declarations of ICU Driver                                                      */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.3:  08/04/2022  : Add version information for AUTOSAR release version, Module Software version.
 * 1.4.1:  15/09/2021  : Changed param name ICU_TIMER_CH_CONFIGURED to ICU_TAU_UNIT_USED
 * 1.3.2:  30/08/2021  : Update header file macro.
 *         24/08/2021  : Add pre-compile parameters (ICU_EDGE_DETECT_API == STD_ON) for Icu_HW_Tau_StartCountMeasurement
 *                       and Icu_HW_Tau_StopCountMeasurement
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/
#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)
        #ifndef ICU_59_INST0_TAU_LLDRIVER_H
            #define ICU_59_INST0_TAU_LLDRIVER_H
            #define ICU_TAU_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_TAU_LLDRIVER_H
            #define ICU_59_INST1_TAU_LLDRIVER_H
            #define ICU_TAU_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_TAU_LLDRIVER_H
            #define ICU_59_INST2_TAU_LLDRIVER_H
            #define ICU_TAU_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_TAU_LLDRIVER_H
            #define ICU_59_INST3_TAU_LLDRIVER_H
            #define ICU_TAU_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_TAU_LLDRIVER_H
            #define ICU_59_INST4_TAU_LLDRIVER_H
            #define ICU_TAU_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_TAU_LLDRIVER_H
            #define ICU_59_INST5_TAU_LLDRIVER_H
            #define ICU_TAU_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_TAU_LLDRIVER_H
            #define ICU_59_INST6_TAU_LLDRIVER_H
            #define ICU_TAU_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_TAU_LLDRIVER_H
            #define ICU_59_INST7_TAU_LLDRIVER_H
            #define ICU_TAU_LLDRIVER_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_TAU_LLDRIVER_H
        #define ICU_TAU_LLDRIVER_H
        #define ICU_TAU_LLDRIVER_HEADER
    #endif
#endif

#ifdef ICU_TAU_LLDRIVER_HEADER
#undef ICU_TAU_LLDRIVER_HEADER                                                                                          /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Include type definition */
#include "Icu_PBTypes.h"
/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ICU_TAU_LLDRIVER_AR_RELEASE_MAJOR_VERSION    ICU_AR_RELEASE_MAJOR_VERSION
#define ICU_TAU_LLDRIVER_AR_RELEASE_MINOR_VERSION    ICU_AR_RELEASE_MINOR_VERSION
#define ICU_TAU_LLDRIVER_AR_RELEASE_REVISION_VERSION ICU_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ICU_TAU_LLDRIVER_SW_MAJOR_VERSION            ICU_SW_MAJOR_VERSION
#define ICU_TAU_LLDRIVER_SW_MINOR_VERSION            ICU_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#if (STD_ON == ICU_TAU_UNIT_USED)
#if ((ICU_TIMESTAMP_API == STD_ON) || (ICU_EDGE_COUNT_API == STD_ON) || (ICU_SIGNAL_MEASUREMENT_API == STD_ON) || \
                                                                                        (ICU_EDGE_DETECT_API == STD_ON))
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tau_StartCountMeasurement(const Icu_ChannelType LddChannel);

extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tau_StopCountMeasurement(const Icu_ChannelType LddChannel);
#endif
#endif /* End of ICU_TAU_UNIT_USED == STD */

#endif /* ICU_TAU_LLDRIVER_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
