/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_MultiInstance.h                                                                                 */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision of API information.                                                                                      */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.4:  16/06/2022  : Update QAC message and QAC header
 * 1.4.1:  15/09/2021  : Correct Global pointer, Generate global variable and
 *                          Multi instance for typedef depending on configuration
 *                       Rename Icu_GaaAtu5CommonPrescalerConfig -> Icu_GaaAtuCommonPrescalerConfig,
 *                          Icu_GaaAtu5TimerClkBusConfig -> Icu_GaaAtuTimerClkBusConfig
 *                       Add define for Icu_PINChannelConfigType, STag_Icu_PINChannelConfigType
 * 1.3.2:  30/08/2021  : Update header file macro.
 *                       Change rule for ICU_MULTI macro.
 *                       Add new ICU_MULTIINC macro, TO_STRING macro.
 *                       Define multi for all symbolic constants, DEM ERROR, version information, header file name
 *         10/10/2021  : Add ISR for TIMERC14_CH00->TIMERC14_CH03, TAUD3_CH00->TAUD3_CH15, INTP_CH40->INTP_CH43
 * 1.3.1:  02/07/2021  : Format source code to 120 characters
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/

#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)
        #ifndef ICU_59_INST0_MULTIINSTANCE_H
            #define ICU_59_INST0_MULTIINSTANCE_H
            #define ICU_MULTIINSTANCE_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_MULTIINSTANCE_H
            #define ICU_59_INST1_MULTIINSTANCE_H
            #define ICU_MULTIINSTANCE_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_MULTIINSTANCE_H
            #define ICU_59_INST2_MULTIINSTANCE_H
            #define ICU_MULTIINSTANCE_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_MULTIINSTANCE_H
            #define ICU_59_INST3_MULTIINSTANCE_H
            #define ICU_MULTIINSTANCE_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_MULTIINSTANCE_H
            #define ICU_59_INST4_MULTIINSTANCE_H
            #define ICU_MULTIINSTANCE_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_MULTIINSTANCE_H
            #define ICU_59_INST5_MULTIINSTANCE_H
            #define ICU_MULTIINSTANCE_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_MULTIINSTANCE_H
            #define ICU_59_INST6_MULTIINSTANCE_H
            #define ICU_MULTIINSTANCE_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_MULTIINSTANCE_H
            #define ICU_59_INST7_MULTIINSTANCE_H
            #define ICU_MULTIINSTANCE_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_MULTIINSTANCE_H
        #define ICU_MULTIINSTANCE_H
        #define ICU_MULTIINSTANCE_HEADER
    #endif
#endif

#ifdef ICU_MULTIINSTANCE_HEADER
#undef ICU_MULTIINSTANCE_HEADER                                                                                         /* PRQA S 0841 # JV-01 */

#define ICU_INCLUDE_FROM_MCAL

/* ICU_USE_MULTIINSTANCE is passed by -D option */
#ifdef ICU_INSTANCE_INDEX

/* Add index to all global symbols. INSTANCE_INDEX is passed by -D option */
#define ICU_MULTIINC(pre_symbol, suf_symbol)             ICU_MULTIINC_(pre_symbol, suf_symbol, ICU_INSTANCE_INDEX)
/* To evaluate INSTANCE_INDEX before concatenation, nest the macro */
#define ICU_MULTIINC_(pre_symbol, suf_symbol, index)     ICU_MULTIINC__(pre_symbol, suf_symbol, index)
#define ICU_MULTIINC__(pre_symbol, suf_symbol, index)    pre_symbol##index##suf_symbol.h

/* String conversion macro */
#define TO_STRING(str)                                   TO_STRING_(str)
#define TO_STRING_(str)                                  #str

/* Add index to all global symbols. ICU_INSTANCE_INDEX is passed by -D option */
#define ICU_MULTI(pre_symbol, suf_symbol)                ICU_MULTI_(pre_symbol, suf_symbol, ICU_INSTANCE_INDEX)
/* To evaluate ICU_INSTANCE_INDEX before concatenation, nest the macro */
#define ICU_MULTI_(pre_symbol, suf_symbol, index)        ICU_MULTI__(pre_symbol, suf_symbol, index)
#define ICU_MULTI__(pre_symbol, suf_symbol, index)       pre_symbol##index##suf_symbol

/* Multi instance all symbolic constants */
/* API */
#define Icu_Init                                         ICU_MULTI(Icu_59_Inst, _Init)
#define Icu_DeInit                                       ICU_MULTI(Icu_59_Inst, _DeInit)
#define Icu_SetActivationCondition                       ICU_MULTI(Icu_59_Inst, _SetActivationCondition)
#define Icu_DisableNotification                          ICU_MULTI(Icu_59_Inst, _DisableNotification)
#define Icu_DisableWakeup                                ICU_MULTI(Icu_59_Inst, _DisableWakeup)
#define Icu_EnableWakeup                                 ICU_MULTI(Icu_59_Inst, _EnableWakeup)
#define Icu_CheckWakeup                                  ICU_MULTI(Icu_59_Inst, _CheckWakeup)
#define Icu_EnableNotification                           ICU_MULTI(Icu_59_Inst, _EnableNotification)
#define Icu_GetInputState                                ICU_MULTI(Icu_59_Inst, _GetInputState)
#define Icu_StartTimestamp                               ICU_MULTI(Icu_59_Inst, _StartTimestamp)
#define Icu_StopTimestamp                                ICU_MULTI(Icu_59_Inst, _StopTimestamp)
#define Icu_GetTimestampIndex                            ICU_MULTI(Icu_59_Inst, _GetTimestampIndex)
#define Icu_ResetEdgeCount                               ICU_MULTI(Icu_59_Inst, _ResetEdgeCount)
#define Icu_EnableEdgeCount                              ICU_MULTI(Icu_59_Inst, _EnableEdgeCount)
#define Icu_DisableEdgeCount                             ICU_MULTI(Icu_59_Inst, _DisableEdgeCount)
#define Icu_EnableEdgeDetection                          ICU_MULTI(Icu_59_Inst, _EnableEdgeDetection)
#define Icu_DisableEdgeDetection                         ICU_MULTI(Icu_59_Inst, _DisableEdgeDetection)
#define Icu_GetEdgeNumbers                               ICU_MULTI(Icu_59_Inst, _GetEdgeNumbers)
#define Icu_GetTAUInCountValue                           ICU_MULTI(Icu_59_Inst, _GetTAUInCountValue)
#define Icu_StartSignalMeasurement                       ICU_MULTI(Icu_59_Inst, _StartSignalMeasurement)
#define Icu_StopSignalMeasurement                        ICU_MULTI(Icu_59_Inst, _StopSignalMeasurement)
#define Icu_GetTimeElapsed                               ICU_MULTI(Icu_59_Inst, _GetTimeElapsed)
#define Icu_GetDutyCycleValues                           ICU_MULTI(Icu_59_Inst, _GetDutyCycleValues)
#define Icu_GetInputLevel                                ICU_MULTI(Icu_59_Inst, _GetInputLevel)
#define Icu_GetVersionInfo                               ICU_MULTI(Icu_59_Inst, _GetVersionInfo)
#define Icu_SetMode                                      ICU_MULTI(Icu_59_Inst, _SetMode)

/* Internal Function */
#define Icu_HW_Atu_UnitInit                              ICU_MULTI(Icu_59_Inst, _HW_Atu_UnitInit)
#define Icu_HW_Atu_ChannelInit                           ICU_MULTI(Icu_59_Inst, _HW_Atu_ChannelInit)
#define Icu_HW_Atu_UnitDeInit                            ICU_MULTI(Icu_59_Inst, _HW_Atu_UnitDeInit)
#define Icu_HW_Atu_ChannelDeInit                         ICU_MULTI(Icu_59_Inst, _HW_Atu_ChannelDeInit)
#define Icu_HW_Atu_EdgeCountingInit                      ICU_MULTI(Icu_59_Inst, _HW_Atu_EdgeCountingInit)
#define Icu_HW_Atu_TimestampInit                         ICU_MULTI(Icu_59_Inst, _HW_Atu_TimestampInit)
#define Icu_HW_Atu_SignalMeasurementInit                 ICU_MULTI(Icu_59_Inst, _HW_Atu_SignalMeasurementInit)
#define Icu_HW_Atu_SetActivation                         ICU_MULTI(Icu_59_Inst, _HW_Atu_SetActivation)
#define Icu_HW_Atu_StartCountMeasurement                 ICU_MULTI(Icu_59_Inst, _HW_Atu_StartCountMeasurement)
#define Icu_HW_Atu_StopCountMeasurement                  ICU_MULTI(Icu_59_Inst, _HW_Atu_StopCountMeasurement)
#define Icu_HW_Atu_ResetEdgeCount                        ICU_MULTI(Icu_59_Inst, _HW_Atu_ResetEdgeCount)
#define Icu_HW_Atu_EnableEdgeDetection                   ICU_MULTI(Icu_59_Inst, _HW_Atu_EnableEdgeDetection)
#define Icu_HW_Atu_DisableEdgeDetection                  ICU_MULTI(Icu_59_Inst, _HW_Atu_DisableEdgeDetection)
#define Icu_ServiceSignalMeasurement                     ICU_MULTI(Icu_59_Inst, _ServiceSignalMeasurement)
#define Icu_ServiceTimestamp                             ICU_MULTI(Icu_59_Inst, _ServiceTimestamp)
#define Icu_TimerIsr                                     ICU_MULTI(Icu_59_Inst, _TimerIsr)
#define Icu_AtuFunc                                      ICU_MULTI(Icu_59_Inst, _AtuFunc)
#define Icu_HW_GetInputLevel                             ICU_MULTI(Icu_59_Inst, _HW_GetInputLevel)
#define Icu_HW_Tau_StartCountMeasurement                 ICU_MULTI(Icu_59_Inst, _HW_Tau_StartCountMeasurement)
#define Icu_HW_Tau_StopCountMeasurement                  ICU_MULTI(Icu_59_Inst, _HW_Tau_StopCountMeasurement)
#define Icu_HW_Taud_UnitInit                             ICU_MULTI(Icu_59_Inst, _HW_Taud_UnitInit)
#define Icu_HW_Taud_ChannelInit                          ICU_MULTI(Icu_59_Inst, _HW_Taud_ChannelInit)
#define Icu_HW_Taud_UnitDeInit                           ICU_MULTI(Icu_59_Inst, _HW_Taud_UnitDeInit)
#define Icu_HW_Taud_ChannelDeInit                        ICU_MULTI(Icu_59_Inst, _HW_Taud_ChannelDeInit)
#define Icu_HW_Taud_TimestampInit                        ICU_MULTI(Icu_59_Inst, _HW_Taud_TimestampInit)
#define Icu_HW_Taud_SignalMeasurementInit                ICU_MULTI(Icu_59_Inst, _HW_Taud_SignalMeasurementInit)
#define Icu_HW_Taud_SetActivation                        ICU_MULTI(Icu_59_Inst, _HW_Taud_SetActivation)
#define Icu_HW_Taud_DisableEdgeDetection                 ICU_MULTI(Icu_59_Inst, _HW_Taud_DisableEdgeDetection)
#define Icu_HW_Taud_StartCountMeasurement                ICU_MULTI(Icu_59_Inst, _HW_Taud_StartCountMeasurement)
#define Icu_HW_Taud_StopCountMeasurement                 ICU_MULTI(Icu_59_Inst, _HW_Taud_StopCountMeasurement)
#define Icu_HW_Taud_GetEdgeNumbers                       ICU_MULTI(Icu_59_Inst, _HW_Taud_GetEdgeNumbers)
#define Icu_HW_Taud_ResetEdgeCount                       ICU_MULTI(Icu_59_Inst, _HW_Taud_ResetEdgeCount)
#define Icu_HW_Taud_GetTAUInCountValue                   ICU_MULTI(Icu_59_Inst, _HW_Taud_GetTAUInCountValue)
#define Icu_HW_Taud_SetMode                              ICU_MULTI(Icu_59_Inst, _HW_Taud_SetMode)
#define Icu_HW_Taud_ServiceSignalMeasurement             ICU_MULTI(Icu_59_Inst, _HW_Taud_ServiceSignalMeasurement)
#define Icu_HW_Taud_ServiceTimestamp                     ICU_MULTI(Icu_59_Inst, _HW_Taud_ServiceTimestamp)
#define Icu_HW_Taud_TimerIsr                             ICU_MULTI(Icu_59_Inst, _HW_Taud_TimerIsr)
#define Icu_HW_Taud_EnableEdgeDetection                  ICU_MULTI(Icu_59_Inst, _HW_Taud_EnableEdgeDetection)
#define Icu_TaudFunc                                     ICU_MULTI(Icu_59_Inst, _TaudFunc)
#define Icu_HW_Tauj_UnitInit                             ICU_MULTI(Icu_59_Inst, _HW_Tauj_UnitInit)
#define Icu_HW_Tauj_ChannelInit                          ICU_MULTI(Icu_59_Inst, _HW_Tauj_ChannelInit)
#define Icu_HW_Tauj_UnitDeInit                           ICU_MULTI(Icu_59_Inst, _HW_Tauj_UnitDeInit)
#define Icu_HW_Tauj_ChannelDeInit                        ICU_MULTI(Icu_59_Inst, _HW_Tauj_ChannelDeInit)
#define Icu_HW_Tauj_TimestampInit                        ICU_MULTI(Icu_59_Inst, _HW_Tauj_TimestampInit)
#define Icu_HW_Tauj_SignalMeasurementInit                ICU_MULTI(Icu_59_Inst, _HW_Tauj_SignalMeasurementInit)
#define Icu_HW_Tauj_SetActivation                        ICU_MULTI(Icu_59_Inst, _HW_Tauj_SetActivation)
#define Icu_HW_Tauj_StartCountMeasurement                ICU_MULTI(Icu_59_Inst, _HW_Tauj_StartCountMeasurement)
#define Icu_HW_Tauj_StopCountMeasurement                 ICU_MULTI(Icu_59_Inst, _HW_Tauj_StopCountMeasurement)
#define Icu_HW_Tauj_GetTAUInCountValue                   ICU_MULTI(Icu_59_Inst, _HW_Tauj_GetTAUInCountValue)
#define Icu_HW_Tauj_SetMode                              ICU_MULTI(Icu_59_Inst, _HW_Tauj_SetMode)
#define Icu_HW_Tauj_ServiceSignalMeasurement             ICU_MULTI(Icu_59_Inst, _HW_Tauj_ServiceSignalMeasurement)
#define Icu_HW_Tauj_ServiceTimestamp                     ICU_MULTI(Icu_59_Inst, _HW_Tauj_ServiceTimestamp)
#define Icu_HW_Tauj_TimerIsr                             ICU_MULTI(Icu_59_Inst, _HW_Tauj_TimerIsr)
#define Icu_TaujFunc                                     ICU_MULTI(Icu_59_Inst, _TaujFunc)
#define Icu_HW_Pin_ChannelInit                           ICU_MULTI(Icu_59_Inst, _HW_Pin_ChannelInit)
#define Icu_HW_Pin_ChannelDeInit                         ICU_MULTI(Icu_59_Inst, _HW_Pin_ChannelDeInit)
#define Icu_HW_Pin_SetActivation                         ICU_MULTI(Icu_59_Inst, _HW_Pin_SetActivation)
#define Icu_HW_Pin_SetMode                               ICU_MULTI(Icu_59_Inst, _HW_Pin_SetMode)
#define Icu_HW_Pin_EnableEdgeDetection                   ICU_MULTI(Icu_59_Inst, _HW_Pin_EnableEdgeDetection)
#define Icu_HW_Pin_DisableEdgeDetection                  ICU_MULTI(Icu_59_Inst, _HW_Pin_DisableEdgeDetection)
#define Icu_HW_Pin_ExternalInterruptIsr                  ICU_MULTI(Icu_59_Inst, _HW_Pin_ExternalInterruptIsr)
#define Icu_ExtIntFunc                                   ICU_MULTI(Icu_59_Inst, _ExtIntFunc)
#define Icu_SetDriverStatus                              ICU_MULTI(Icu_59_Inst, _SetDriverStatus)

/* Interrupt handler */
#define ICU_ATU_TIMERA0_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERA0_CH00_ISR_API)
#define ICU_ATU_TIMERA0_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERA0_CH01_ISR_API)
#define ICU_ATU_TIMERA0_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERA0_CH02_ISR_API)
#define ICU_ATU_TIMERA0_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERA0_CH03_ISR_API)
#define ICU_ATU_TIMERA0_CH04_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERA0_CH04_ISR_API)
#define ICU_ATU_TIMERA0_CH05_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERA0_CH05_ISR_API)
#define ICU_ATU_TIMERA0_CH06_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERA0_CH06_ISR_API)
#define ICU_ATU_TIMERA0_CH07_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERA0_CH07_ISR_API)
#define ICU_ATU_TIMERC0_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC0_CH00_ISR_API)
#define ICU_ATU_TIMERC0_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC0_CH01_ISR_API)
#define ICU_ATU_TIMERC0_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC0_CH02_ISR_API)
#define ICU_ATU_TIMERC0_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC0_CH03_ISR_API)
#define ICU_ATU_TIMERC1_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC1_CH00_ISR_API)
#define ICU_ATU_TIMERC1_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC1_CH01_ISR_API)
#define ICU_ATU_TIMERC1_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC1_CH02_ISR_API)
#define ICU_ATU_TIMERC1_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC1_CH03_ISR_API)
#define ICU_ATU_TIMERC2_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC2_CH00_ISR_API)
#define ICU_ATU_TIMERC2_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC2_CH01_ISR_API)
#define ICU_ATU_TIMERC2_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC2_CH02_ISR_API)
#define ICU_ATU_TIMERC2_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC2_CH03_ISR_API)
#define ICU_ATU_TIMERC3_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC3_CH00_ISR_API)
#define ICU_ATU_TIMERC3_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC3_CH01_ISR_API)
#define ICU_ATU_TIMERC3_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC3_CH02_ISR_API)
#define ICU_ATU_TIMERC3_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC3_CH03_ISR_API)
#define ICU_ATU_TIMERC4_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC4_CH00_ISR_API)
#define ICU_ATU_TIMERC4_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC4_CH01_ISR_API)
#define ICU_ATU_TIMERC4_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC4_CH02_ISR_API)
#define ICU_ATU_TIMERC4_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC4_CH03_ISR_API)
#define ICU_ATU_TIMERC5_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC5_CH00_ISR_API)
#define ICU_ATU_TIMERC5_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC5_CH01_ISR_API)
#define ICU_ATU_TIMERC5_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC5_CH02_ISR_API)
#define ICU_ATU_TIMERC5_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC5_CH03_ISR_API)
#define ICU_ATU_TIMERC6_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC6_CH00_ISR_API)
#define ICU_ATU_TIMERC6_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC6_CH01_ISR_API)
#define ICU_ATU_TIMERC6_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC6_CH02_ISR_API)
#define ICU_ATU_TIMERC6_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC6_CH03_ISR_API)
#define ICU_ATU_TIMERC7_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC7_CH00_ISR_API)
#define ICU_ATU_TIMERC7_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC7_CH01_ISR_API)
#define ICU_ATU_TIMERC7_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC7_CH02_ISR_API)
#define ICU_ATU_TIMERC7_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC7_CH03_ISR_API)
#define ICU_ATU_TIMERC8_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC8_CH00_ISR_API)
#define ICU_ATU_TIMERC8_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC8_CH01_ISR_API)
#define ICU_ATU_TIMERC8_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC8_CH02_ISR_API)
#define ICU_ATU_TIMERC8_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC8_CH03_ISR_API)
#define ICU_ATU_TIMERC9_CH00_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC9_CH00_ISR_API)
#define ICU_ATU_TIMERC9_CH01_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC9_CH01_ISR_API)
#define ICU_ATU_TIMERC9_CH02_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC9_CH02_ISR_API)
#define ICU_ATU_TIMERC9_CH03_ISR_API                     ICU_MULTI(ICU_59_INST, _ATU_TIMERC9_CH03_ISR_API)
#define ICU_ATU_TIMERC10_CH00_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC10_CH00_ISR_API)
#define ICU_ATU_TIMERC10_CH01_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC10_CH01_ISR_API)
#define ICU_ATU_TIMERC10_CH02_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC10_CH02_ISR_API)
#define ICU_ATU_TIMERC10_CH03_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC10_CH03_ISR_API)
#define ICU_ATU_TIMERC11_CH00_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC11_CH00_ISR_API)
#define ICU_ATU_TIMERC11_CH01_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC11_CH01_ISR_API)
#define ICU_ATU_TIMERC11_CH02_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC11_CH02_ISR_API)
#define ICU_ATU_TIMERC11_CH03_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC11_CH03_ISR_API)
#define ICU_ATU_TIMERC12_CH00_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC12_CH00_ISR_API)
#define ICU_ATU_TIMERC12_CH01_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC12_CH01_ISR_API)
#define ICU_ATU_TIMERC12_CH02_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC12_CH02_ISR_API)
#define ICU_ATU_TIMERC12_CH03_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC12_CH03_ISR_API)
#define ICU_ATU_TIMERC13_CH00_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC13_CH00_ISR_API)
#define ICU_ATU_TIMERC13_CH01_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC13_CH01_ISR_API)
#define ICU_ATU_TIMERC13_CH02_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC13_CH02_ISR_API)
#define ICU_ATU_TIMERC13_CH03_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC13_CH03_ISR_API)
#define ICU_ATU_TIMERC14_CH00_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC14_CH00_ISR_API)
#define ICU_ATU_TIMERC14_CH01_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC14_CH01_ISR_API)
#define ICU_ATU_TIMERC14_CH02_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC14_CH02_ISR_API)
#define ICU_ATU_TIMERC14_CH03_ISR_API                    ICU_MULTI(ICU_59_INST, _ATU_TIMERC14_CH03_ISR_API)
#define ICU_EXT_IRQ_CH00_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH00_ISR_API)
#define ICU_EXT_IRQ_CH01_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH01_ISR_API)
#define ICU_EXT_IRQ_CH02_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH02_ISR_API)
#define ICU_EXT_IRQ_CH03_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH03_ISR_API)
#define ICU_EXT_IRQ_CH04_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH04_ISR_API)
#define ICU_EXT_IRQ_CH05_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH05_ISR_API)
#define ICU_EXT_IRQ_CH06_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH06_ISR_API)
#define ICU_EXT_IRQ_CH07_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH07_ISR_API)
#define ICU_EXT_IRQ_CH08_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH08_ISR_API)
#define ICU_EXT_IRQ_CH09_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH09_ISR_API)
#define ICU_EXT_IRQ_CH10_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH10_ISR_API)
#define ICU_EXT_IRQ_CH11_ISR_API                         ICU_MULTI(ICU_59_INST, _EXT_IRQ_CH11_ISR_API)

/* For U2x*/
#define ICU_TAUD0_CH00_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH00_ISR_API)
#define ICU_TAUD0_CH01_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH01_ISR_API)
#define ICU_TAUD0_CH02_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH02_ISR_API)
#define ICU_TAUD0_CH03_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH03_ISR_API)
#define ICU_TAUD0_CH04_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH04_ISR_API)
#define ICU_TAUD0_CH05_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH05_ISR_API)
#define ICU_TAUD0_CH06_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH06_ISR_API)
#define ICU_TAUD0_CH07_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH07_ISR_API)
#define ICU_TAUD0_CH08_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH08_ISR_API)
#define ICU_TAUD0_CH09_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH09_ISR_API)
#define ICU_TAUD0_CH10_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH10_ISR_API)
#define ICU_TAUD0_CH11_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH11_ISR_API)
#define ICU_TAUD0_CH12_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH12_ISR_API)
#define ICU_TAUD0_CH13_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH13_ISR_API)
#define ICU_TAUD0_CH14_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH14_ISR_API)
#define ICU_TAUD0_CH15_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD0_CH15_ISR_API)
#define ICU_TAUD1_CH00_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH00_ISR_API)
#define ICU_TAUD1_CH01_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH01_ISR_API)
#define ICU_TAUD1_CH02_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH02_ISR_API)
#define ICU_TAUD1_CH03_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH03_ISR_API)
#define ICU_TAUD1_CH04_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH04_ISR_API)
#define ICU_TAUD1_CH05_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH05_ISR_API)
#define ICU_TAUD1_CH06_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH06_ISR_API)
#define ICU_TAUD1_CH07_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH07_ISR_API)
#define ICU_TAUD1_CH08_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH08_ISR_API)
#define ICU_TAUD1_CH09_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH09_ISR_API)
#define ICU_TAUD1_CH10_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH10_ISR_API)
#define ICU_TAUD1_CH11_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH11_ISR_API)
#define ICU_TAUD1_CH12_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH12_ISR_API)
#define ICU_TAUD1_CH13_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH13_ISR_API)
#define ICU_TAUD1_CH14_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH14_ISR_API)
#define ICU_TAUD1_CH15_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD1_CH15_ISR_API)
#define ICU_TAUD2_CH00_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH00_ISR_API)
#define ICU_TAUD2_CH01_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH01_ISR_API)
#define ICU_TAUD2_CH02_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH02_ISR_API)
#define ICU_TAUD2_CH03_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH03_ISR_API)
#define ICU_TAUD2_CH04_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH04_ISR_API)
#define ICU_TAUD2_CH05_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH05_ISR_API)
#define ICU_TAUD2_CH06_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH06_ISR_API)
#define ICU_TAUD2_CH07_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH07_ISR_API)
#define ICU_TAUD2_CH08_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH08_ISR_API)
#define ICU_TAUD2_CH09_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH09_ISR_API)
#define ICU_TAUD2_CH10_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH10_ISR_API)
#define ICU_TAUD2_CH11_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH11_ISR_API)
#define ICU_TAUD2_CH12_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH12_ISR_API)
#define ICU_TAUD2_CH13_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH13_ISR_API)
#define ICU_TAUD2_CH14_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH14_ISR_API)
#define ICU_TAUD2_CH15_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD2_CH15_ISR_API)
#define ICU_TAUD3_CH00_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH00_ISR_API)
#define ICU_TAUD3_CH01_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH01_ISR_API)
#define ICU_TAUD3_CH02_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH02_ISR_API)
#define ICU_TAUD3_CH03_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH03_ISR_API)
#define ICU_TAUD3_CH04_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH04_ISR_API)
#define ICU_TAUD3_CH05_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH05_ISR_API)
#define ICU_TAUD3_CH06_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH06_ISR_API)
#define ICU_TAUD3_CH07_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH07_ISR_API)
#define ICU_TAUD3_CH08_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH08_ISR_API)
#define ICU_TAUD3_CH09_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH09_ISR_API)
#define ICU_TAUD3_CH10_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH10_ISR_API)
#define ICU_TAUD3_CH11_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH11_ISR_API)
#define ICU_TAUD3_CH12_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH12_ISR_API)
#define ICU_TAUD3_CH13_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH13_ISR_API)
#define ICU_TAUD3_CH14_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH14_ISR_API)
#define ICU_TAUD3_CH15_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUD3_CH15_ISR_API)
#define ICU_TAUJ0_CH00_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ0_CH00_ISR_API)
#define ICU_TAUJ0_CH01_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ0_CH01_ISR_API)
#define ICU_TAUJ0_CH02_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ0_CH02_ISR_API)
#define ICU_TAUJ0_CH03_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ0_CH03_ISR_API)
#define ICU_TAUJ1_CH00_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ1_CH00_ISR_API)
#define ICU_TAUJ1_CH01_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ1_CH01_ISR_API)
#define ICU_TAUJ1_CH02_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ1_CH02_ISR_API)
#define ICU_TAUJ1_CH03_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ1_CH03_ISR_API)
#define ICU_TAUJ2_CH00_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ2_CH00_ISR_API)
#define ICU_TAUJ2_CH01_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ2_CH01_ISR_API)
#define ICU_TAUJ2_CH02_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ2_CH02_ISR_API)
#define ICU_TAUJ2_CH03_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ2_CH03_ISR_API)
#define ICU_TAUJ3_CH00_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ3_CH00_ISR_API)
#define ICU_TAUJ3_CH01_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ3_CH01_ISR_API)
#define ICU_TAUJ3_CH02_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ3_CH02_ISR_API)
#define ICU_TAUJ3_CH03_ISR_API                           ICU_MULTI(ICU_59_INST, _TAUJ3_CH03_ISR_API)
#define ICU_EXT_INTP_CH00_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH00_ISR_API)
#define ICU_EXT_INTP_CH01_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH01_ISR_API)
#define ICU_EXT_INTP_CH02_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH02_ISR_API)
#define ICU_EXT_INTP_CH03_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH03_ISR_API)
#define ICU_EXT_INTP_CH04_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH04_ISR_API)
#define ICU_EXT_INTP_CH05_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH05_ISR_API)
#define ICU_EXT_INTP_CH06_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH06_ISR_API)
#define ICU_EXT_INTP_CH07_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH07_ISR_API)
#define ICU_EXT_INTP_CH08_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH08_ISR_API)
#define ICU_EXT_INTP_CH09_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH09_ISR_API)
#define ICU_EXT_INTP_CH10_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH10_ISR_API)
#define ICU_EXT_INTP_CH11_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH11_ISR_API)
#define ICU_EXT_INTP_CH12_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH12_ISR_API)
#define ICU_EXT_INTP_CH13_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH13_ISR_API)
#define ICU_EXT_INTP_CH14_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH14_ISR_API)
#define ICU_EXT_INTP_CH15_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH15_ISR_API)
#define ICU_EXT_INTP_CH16_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH16_ISR_API)
#define ICU_EXT_INTP_CH17_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH17_ISR_API)
#define ICU_EXT_INTP_CH18_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH18_ISR_API)
#define ICU_EXT_INTP_CH19_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH19_ISR_API)
#define ICU_EXT_INTP_CH20_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH20_ISR_API)
#define ICU_EXT_INTP_CH21_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH21_ISR_API)
#define ICU_EXT_INTP_CH22_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH22_ISR_API)
#define ICU_EXT_INTP_CH23_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH23_ISR_API)
#define ICU_EXT_INTP_CH24_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH24_ISR_API)
#define ICU_EXT_INTP_CH25_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH25_ISR_API)
#define ICU_EXT_INTP_CH26_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH26_ISR_API)
#define ICU_EXT_INTP_CH27_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH27_ISR_API)
#define ICU_EXT_INTP_CH28_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH28_ISR_API)
#define ICU_EXT_INTP_CH29_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH29_ISR_API)
#define ICU_EXT_INTP_CH30_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH30_ISR_API)
#define ICU_EXT_INTP_CH31_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH31_ISR_API)
#define ICU_EXT_INTP_CH32_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH32_ISR_API)
#define ICU_EXT_INTP_CH33_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH33_ISR_API)
#define ICU_EXT_INTP_CH34_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH34_ISR_API)
#define ICU_EXT_INTP_CH35_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH35_ISR_API)
#define ICU_EXT_INTP_CH36_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH36_ISR_API)
#define ICU_EXT_INTP_CH37_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH37_ISR_API)
#define ICU_EXT_INTP_CH38_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH38_ISR_API)
#define ICU_EXT_INTP_CH39_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH39_ISR_API)
#define ICU_EXT_INTP_CH40_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH40_ISR_API)
#define ICU_EXT_INTP_CH41_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH41_ISR_API)
#define ICU_EXT_INTP_CH42_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH42_ISR_API)
#define ICU_EXT_INTP_CH43_ISR_API                        ICU_MULTI(ICU_59_INST, _EXT_INTP_CH43_ISR_API)

/* Global pointer */                                     
#define Icu_GpTAUUnitConfig                              ICU_MULTI(Icu_59_Inst, _GpTAUUnitConfig)
#define Icu_GpChannelConfig                              ICU_MULTI(Icu_59_Inst, _GpChannelConfig)
#define Icu_GpChannelRamData                             ICU_MULTI(Icu_59_Inst, _GpChannelRamData)
#define Icu_GpEdgeCountData                              ICU_MULTI(Icu_59_Inst, _GpEdgeCountData)
#define Icu_GpTimeStampData                              ICU_MULTI(Icu_59_Inst, _GpTimeStampData)
#define Icu_GpSignalMeasurementData                      ICU_MULTI(Icu_59_Inst, _GpSignalMeasurementData)
#define Icu_GpTimerClkBusConfig                          ICU_MULTI(Icu_59_Inst, _GpTimerClkBusConfig)
#define Icu_GpChannelUserRegConfig                       ICU_MULTI(Icu_59_Inst, _GpChannelUserRegConfig)
#define Icu_GpNoiseCancellationConfig                    ICU_MULTI(Icu_59_Inst, _GpNoiseCancellationConfig)

/* Global variable */
#define Icu_GblDriverStatus                              ICU_MULTI(Icu_59_Inst, _GblDriverStatus)
#define Icu_GulWakeupSource                              ICU_MULTI(Icu_59_Inst, _GulWakeupSource)

/* Generate global variable */
#define Icu_GaaTimestampRamData                          ICU_MULTI(Icu_59_Inst, _GaaTimestampRamData)
#define Icu_GaaEdgeCountRamData                          ICU_MULTI(Icu_59_Inst, _GaaEdgeCountRamData)
#define Icu_GaaConfiguration                             ICU_MULTI(Icu_59_Inst, _GaaConfiguration)
#define Icu_GaaChannelRamData                            ICU_MULTI(Icu_59_Inst, _GaaChannelRamData)
#define Icu_GaaSignalMeasureRamData                      ICU_MULTI(Icu_59_Inst, _GaaSignalMeasureRamData)
#define Icu_GaaATUChannelUserRegConfig                   ICU_MULTI(Icu_59_Inst, _GaaATUChannelUserRegConfig)
#define Icu_GaaATUConfig                                 ICU_MULTI(Icu_59_Inst, _GaaATUConfig)
#define Icu_GaaATUChannelConfig                          ICU_MULTI(Icu_59_Inst, _GaaATUChannelConfig)
#define Icu_GaaPINChannelConfig                          ICU_MULTI(Icu_59_Inst, _GaaPINChannelConfig)
#define Icu_GaaTAUChannelUserRegConfig                   ICU_MULTI(Icu_59_Inst, _GaaTAUChannelUserRegConfig)
#define Icu_GaaPINChannelUserRegConfig                   ICU_MULTI(Icu_59_Inst, _GaaPINChannelUserRegConfig)
#define Icu_GaaTAUChannelConfig                          ICU_MULTI(Icu_59_Inst, _GaaTAUChannelConfig)
#define Icu_GaaAtuTimerClkBusConfig                      ICU_MULTI(Icu_59_Inst, _GaaAtuTimerClkBusConfig)
#define Icu_GaaNoiseCancellationConfig                   ICU_MULTI(Icu_59_Inst, _GaaNoiseCancellationConfig)
#define Icu_GaaNCCRCCntrlRegConfig                       ICU_MULTI(Icu_59_Inst, _GaaNCCRCCntrlRegConfig)
#define Icu_GaaChannelConfig                             ICU_MULTI(Icu_59_Inst, _GaaChannelConfig)
#define Icu_GaaChannelUserRegConfig                      ICU_MULTI(Icu_59_Inst, _GaaChannelUserRegConfig)
#define Icu_GaaAtuCommonPrescalerConfig                  ICU_MULTI(Icu_59_Inst, _GaaAtuCommonPrescalerConfig)
#define Icu_GaaHwDepFunc                                 ICU_MULTI(Icu_59_Inst, _GaaHwDepFunc)
#define Icu_GaaTAUUnitConfig                             ICU_MULTI(Icu_59_Inst, _GaaTAUUnitConfig)
#define Icu_GenModuleMode                                ICU_MULTI(Icu_59_Inst, _GenModuleMode)
#define Icu_GaaHWIPConfig                                ICU_MULTI(Icu_59_Inst, _GaaHWIPConfig)

/* Multi instance for typedef depending on configuration */
#define Icu_ConfigType                                   ICU_MULTI(Icu_59_Inst, _ConfigType)
#define STag_Icu_ConfigType                              ICU_MULTI(STag_Icu_59_Inst, _ConfigType)

#define Icu_ChannelConfigType                            ICU_MULTI(Icu_59_Inst, _ChannelConfigType)
#define STag_Icu_ChannelConfigType                       ICU_MULTI(STag_Icu_59_Inst, _ChannelConfigType)

#define Icu_ChannelUserRegConfigType                     ICU_MULTI(Icu_59_Inst, _ChannelUserRegConfigType)
#define STag_Icu_ChannelUserRegConfigType                ICU_MULTI(STag_Icu_59_Inst, _ChannelUserRegConfigType)

#define Icu_TimeStampChannelRamDataType                  ICU_MULTI(Icu_59_Inst, _TimeStampChannelRamDataType)
#define STag_Icu_TimeStampChannelRamDataType             ICU_MULTI(STag_Icu_59_Inst, _TimeStampChannelRamDataType)

#define Icu_EdgeCountModeRamDatatype                     ICU_MULTI(Icu_59_Inst, _EdgeCountModeRamDatatype)
#define STag_Icu_EdgeCountModeRamDatatype                ICU_MULTI(STag_Icu_59_Inst, _EdgeCountModeRamDatatype)

#define Icu_HWIPType                                     ICU_MULTI(Icu_59_Inst, _HWIPType)
#define STag_Icu_HWIPType                                ICU_MULTI(STag_Icu_59_Inst, _HWIPType)

#define Icu_HwFuncTableType                              ICU_MULTI(Icu_59_Inst, _HwFuncTableType)
#define STag_Icu_HwFuncTableType                         ICU_MULTI(STag_Icu_59_Inst, _HwFuncTableType)

#define Icu_ATUConfigType                                ICU_MULTI(Icu_59_Inst, _ATUConfigType)
#define STag_Icu_ATUConfigType                           ICU_MULTI(STag_Icu_59_Inst, _ATUConfigType)

#define Icu_ATUChannelConfigType                         ICU_MULTI(Icu_59_Inst, _ATUChannelConfigType)
#define STag_Icu_ATUChannelConfigType                    ICU_MULTI(STag_Icu_59_Inst, _ATUChannelConfigType)

#define Icu_ATUChannelUserRegConfigType                  ICU_MULTI(Icu_59_Inst, _ATUChannelUserRegConfigType)
#define STag_Icu_ATUChannelUserRegConfigType             ICU_MULTI(STag_Icu_59_Inst, _ATUChannelUserRegConfigType)

#define Icu_ATU_CommonPrescalerConfigType                ICU_MULTI(Icu_59_Inst, _ATU_CommonPrescalerConfigType)
#define STag_Icu_ATU_CommonPrescalerConfigType           ICU_MULTI(STag_Icu_59_Inst, _ATU_CommonPrescalerConfigType)

#define Icu_ATU_ClockBusConfigType                       ICU_MULTI(Icu_59_Inst, _ATU_ClockBusConfigType)
#define STag_Icu_ATU_ClockBusConfigType                  ICU_MULTI(STag_Icu_59_Inst, _ATU_ClockBusConfigType)

#define Icu_NoiseCancellationConfigType                  ICU_MULTI(Icu_59_Inst, _NoiseCancellationConfigType)
#define STag_Icu_NoiseCancellationConfigType             ICU_MULTI(STag_Icu_59_Inst, _NoiseCancellationConfigType)

#define Icu_NCCRCCntrlRegConfigType                      ICU_MULTI(Icu_59_Inst, _NCCRCCntrlRegConfigType)
#define STag_Icu_NCCRCCntrlRegConfigType                 ICU_MULTI(STag_Icu_59_Inst, _NCCRCCntrlRegConfigType)

#define Icu_SignalMeasurementModeRamDataType             ICU_MULTI(Icu_59_Inst, _SignalMeasurementModeRamDataType)
#define STag_Icu_SignalMeasurementModeRamDataType        ICU_MULTI(STag_Icu_59_Inst, _SignalMeasurementModeRamDataType)

#define Icu_ChannelRamDataType                           ICU_MULTI(Icu_59_Inst, _ChannelRamDataType)
#define STag_Icu_ChannelRamDataType                      ICU_MULTI(STag_Icu_59_Inst, _ChannelRamDataType)

#define Icu_TAUChannelConfigType                         ICU_MULTI(Icu_59_Inst, _TAUChannelConfigType)
#define STag_Icu_TAUChannelConfigType                    ICU_MULTI(STag_Icu_59_Inst, _TAUChannelConfigType)

#define Icu_TAUChannelUserRegConfigType                  ICU_MULTI(Icu_59_Inst, _TAUChannelUserRegConfigType)
#define STag_Icu_TAUChannelUserRegConfigType             ICU_MULTI(STag_Icu_59_Inst, _TAUChannelUserRegConfigType)

#define Icu_TAUUnitConfigType                            ICU_MULTI(Icu_59_Inst, _TAUUnitConfigType)
#define STag_Icu_TAUUnitConfigType                       ICU_MULTI(STag_Icu_59_Inst, _TAUUnitConfigType)

#define Icu_GaaPINChannelUserRegConfig                   ICU_MULTI(Icu_59_Inst, _GaaPINChannelUserRegConfig)
#define STag_Icu_GaaPINChannelUserRegConfig              ICU_MULTI(STag_Icu_59_Inst, _GaaPINChannelUserRegConfig)

#define Icu_PINChannelUserRegConfigType                  ICU_MULTI(Icu_59_Inst, _PINChannelUserRegConfigType)
#define STag_Icu_PINChannelUserRegConfigType             ICU_MULTI(STag_Icu_59_Inst, _PINChannelUserRegConfigType)

#define Icu_PINChannelConfigType                         ICU_MULTI(Icu_59_Inst, _PINChannelConfigType)
#define STag_Icu_PINChannelConfigType                    ICU_MULTI(STag_Icu_59_Inst, _PINChannelConfigType)

#define Icu_ChannelType                                  ICU_MULTI(Icu_59_Inst, _ChannelType)
#define Icu_InputStateType                               ICU_MULTI(Icu_59_Inst, _InputStateType)
#define STag_Icu_InputStateType                          ICU_MULTI(STag_Icu_59_Inst, _InputStateType)
#define Icu_LevelType                                    ICU_MULTI(Icu_59_Inst, _LevelType)
#define STag_Icu_LevelType                               ICU_MULTI(STag_Icu_59_Inst, _LevelType)
#define Icu_ActivationType                               ICU_MULTI(Icu_59_Inst, _ActivationType)
#define STag_Icu_ActivationType                          ICU_MULTI(STag_Icu_59_Inst, _ActivationType)
#define Icu_ValueType                                    ICU_MULTI(Icu_59_Inst, _ValueType)
#define Icu_DutyCycleType                                ICU_MULTI(Icu_59_Inst, _DutyCycleType)
#define STag_Icu_DutyCycleType                           ICU_MULTI(STag_Icu_59_Inst, _DutyCycleType)
#define Icu_IndexType                                    ICU_MULTI(Icu_59_Inst, _IndexType)
#define Icu_EdgeNumberType                               ICU_MULTI(Icu_59_Inst, _EdgeNumberType)
#define Icu_CounterValueType                             ICU_MULTI(Icu_59_Inst, _CounterValueType)
#define Icu_MeasurementModeType                          ICU_MULTI(Icu_59_Inst, _MeasurementModeType)
#define STag_Icu_MeasurementModeType                     ICU_MULTI(STag_Icu_59_Inst, _MeasurementModeType)
#define Icu_SignalMeasurementPropertyType                ICU_MULTI(Icu_59_Inst, _SignalMeasurementPropertyType)
#define STag_Icu_SignalMeasurementPropertyType           ICU_MULTI(STag_Icu_59_Inst, _SignalMeasurementPropertyType)
#define Icu_TimestampBufferType                          ICU_MULTI(Icu_59_Inst, _TimestampBufferType)
#define STag_Icu_TimestampBufferType                     ICU_MULTI(STag_Icu_59_Inst, _TimestampBufferType)

/* Multi instance for macro ISR*/
#define ICU_ISR_CATEGORY_2                               ICU_MULTI(ICU_59_INST, _ISR_CATEGORY_2)

/* Multi instance for DEM ERROR */
#define ICU_E_INT_INCONSISTENT                           ICU_MULTI(ICU_59_INST, _E_INT_INCONSISTENT)

/* Multi instance for version information */              
#define ICU_CFG_AR_RELEASE_MAJOR_VERSION                 ICU_MULTI(ICU_59_INST, _CFG_AR_RELEASE_MAJOR_VERSION)
#define ICU_CFG_AR_RELEASE_MINOR_VERSION                 ICU_MULTI(ICU_59_INST, _CFG_AR_RELEASE_MINOR_VERSION)
#define ICU_CFG_AR_RELEASE_REVISION_VERSION              ICU_MULTI(ICU_59_INST, _CFG_AR_RELEASE_REVISION_VERSION)
#define ICU_CFG_SW_MAJOR_VERSION                         ICU_MULTI(ICU_59_INST, _CFG_SW_MAJOR_VERSION)
#define ICU_CFG_SW_MINOR_VERSION                         ICU_MULTI(ICU_59_INST, _CFG_SW_MINOR_VERSION)
#define ICU_AR_RELEASE_MAJOR_VERSION_VALUE               ICU_MULTI(ICU_59_INST, _AR_RELEASE_MAJOR_VERSION_VALUE)
#define ICU_AR_RELEASE_MINOR_VERSION_VALUE               ICU_MULTI(ICU_59_INST, _AR_RELEASE_MINOR_VERSION_VALUE)
#define ICU_AR_RELEASE_REVISION_VERSION_VALUE            ICU_MULTI(ICU_59_INST, _AR_RELEASE_REVISION_VERSION_VALUE)
#define ICU_SW_MAJOR_VERSION_VALUE                       ICU_MULTI(ICU_59_INST, _SW_MAJOR_VERSION_VALUE)
#define ICU_SW_MINOR_VERSION_VALUE                       ICU_MULTI(ICU_59_INST, _SW_MINOR_VERSION_VALUE)
#define ICU_SW_PATCH_VERSION_VALUE                       ICU_MULTI(ICU_59_INST, _SW_PATCH_VERSION_VALUE)
#define ICU_VENDOR_ID_VALUE                              ICU_MULTI(ICU_59_INST, _VENDOR_ID_VALUE)
#define ICU_MODULE_ID_VALUE                              ICU_MULTI(ICU_59_INST, _MODULE_ID_VALUE)
#define ICU_AR_VERSION                                   ICU_MULTI(ICU_59_INST, _AR_VERSION)
#define ICU_PBCFG_C_AR_RELEASE_MAJOR_VERSION             ICU_MULTI(ICU_59_INST, _PBCFG_C_AR_RELEASE_MAJOR_VERSION)
#define ICU_PBCFG_C_AR_RELEASE_MINOR_VERSION             ICU_MULTI(ICU_59_INST, _PBCFG_C_AR_RELEASE_MINOR_VERSION)
#define ICU_PBCFG_C_AR_RELEASE_REVISION_VERSION          ICU_MULTI(ICU_59_INST, _PBCFG_C_AR_RELEASE_REVISION_VERSION)
#define ICU_PBCFG_C_SW_MAJOR_VERSION                     ICU_MULTI(ICU_59_INST, _PBCFG_C_SW_MAJOR_VERSION)
#define ICU_PBCFG_C_SW_MINOR_VERSION                     ICU_MULTI(ICU_59_INST, _PBCFG_C_SW_MINOR_VERSION)

#define ICU_59_INST0_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ICU_59_INST0_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ICU_59_INST0_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ICU_59_INST0_PBTYPES_SW_MAJOR_VERSION            ICU_PBTYPES_SW_MAJOR_VERSION
#define ICU_59_INST0_PBTYPES_SW_MINOR_VERSION            ICU_PBTYPES_SW_MINOR_VERSION

#define ICU_59_INST1_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ICU_59_INST1_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ICU_59_INST1_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ICU_59_INST1_PBTYPES_SW_MAJOR_VERSION            ICU_PBTYPES_SW_MAJOR_VERSION
#define ICU_59_INST1_PBTYPES_SW_MINOR_VERSION            ICU_PBTYPES_SW_MINOR_VERSION

#define ICU_59_INST2_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ICU_59_INST2_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ICU_59_INST2_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ICU_59_INST2_PBTYPES_SW_MAJOR_VERSION            ICU_PBTYPES_SW_MAJOR_VERSION
#define ICU_59_INST2_PBTYPES_SW_MINOR_VERSION            ICU_PBTYPES_SW_MINOR_VERSION

#define ICU_59_INST3_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ICU_59_INST3_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ICU_59_INST3_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ICU_59_INST3_PBTYPES_SW_MAJOR_VERSION            ICU_PBTYPES_SW_MAJOR_VERSION
#define ICU_59_INST3_PBTYPES_SW_MINOR_VERSION            ICU_PBTYPES_SW_MINOR_VERSION

#define ICU_59_INST4_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ICU_59_INST4_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ICU_59_INST4_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ICU_59_INST4_PBTYPES_SW_MAJOR_VERSION            ICU_PBTYPES_SW_MAJOR_VERSION
#define ICU_59_INST4_PBTYPES_SW_MINOR_VERSION            ICU_PBTYPES_SW_MINOR_VERSION

#define ICU_59_INST5_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ICU_59_INST5_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ICU_59_INST5_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ICU_59_INST5_PBTYPES_SW_MAJOR_VERSION            ICU_PBTYPES_SW_MAJOR_VERSION
#define ICU_59_INST5_PBTYPES_SW_MINOR_VERSION            ICU_PBTYPES_SW_MINOR_VERSION

#define ICU_59_INST6_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ICU_59_INST6_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ICU_59_INST6_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ICU_59_INST6_PBTYPES_SW_MAJOR_VERSION            ICU_PBTYPES_SW_MAJOR_VERSION
#define ICU_59_INST6_PBTYPES_SW_MINOR_VERSION            ICU_PBTYPES_SW_MINOR_VERSION

#define ICU_59_INST7_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ICU_59_INST7_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ICU_59_INST7_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ICU_59_INST7_PBTYPES_SW_MAJOR_VERSION            ICU_PBTYPES_SW_MAJOR_VERSION
#define ICU_59_INST7_PBTYPES_SW_MINOR_VERSION            ICU_PBTYPES_SW_MINOR_VERSION

/* Multi instance for memory class/pointer class */
#define ICU_PUBLIC_CODE                                  ICU_MULTI(ICU_59_INST, _PUBLIC_CODE)
#define ICU_PUBLIC_CONST                                 ICU_MULTI(ICU_59_INST, _PUBLIC_CONST)
#define ICU_PRIVATE_CODE                                 ICU_MULTI(ICU_59_INST, _PRIVATE_CODE)
#define ICU_PRIVATE_CONST                                ICU_MULTI(ICU_59_INST, _PRIVATE_CONST)
#define ICU_APPL_CODE                                    ICU_MULTI(ICU_59_INST, _APPL_CODE)
#define ICU_APPL_CONST                                   ICU_MULTI(ICU_59_INST, _APPL_CONST)
#define ICU_APPL_DATA                                    ICU_MULTI(ICU_59_INST, _APPL_DATA)
#define ICU_VAR_FAST_NO_INIT                             ICU_MULTI(ICU_59_INST, _VAR_FAST_NO_INIT)
#define ICU_CODE_FAST                                    ICU_MULTI(ICU_59_INST, _CODE_FAST)
#define ICU_CONFIG_DATA                                  ICU_MULTI(ICU_59_INST, _CONFIG_DATA)
#define ICU_CONST                                        ICU_MULTI(ICU_59_INST, _CONST)
#define ICU_VAR_INIT                                     ICU_MULTI(ICU_59_INST, _VAR_INIT)
#define ICU_VAR_NO_INIT                                  ICU_MULTI(ICU_59_INST, _VAR_NO_INIT)
#define ICU_VAR                                          ICU_MULTI(ICU_59_INST, _VAR)
#define ICU_VAR_NOINIT                                   ICU_MULTI(ICU_59_INST, _VAR_NOINIT)

/* Define header file name */
#define ICU_MEMMAP_HEADER                                TO_STRING(ICU_MULTIINC(Icu_59_Inst, _MemMap))
#define SCHM_ICU_HEADER                                  TO_STRING(ICU_MULTIINC(SchM_Icu_59_Inst, ))
#define ICU_CFG_HEADER                                   TO_STRING(ICU_MULTIINC(Icu_59_Inst, _Cfg))
#define ICU_CBK_HEADER                                   TO_STRING(ICU_MULTIINC(Icu_59_Inst, _Cbk))

#else
#define ICU_MEMMAP_HEADER "Icu_MemMap.h"
#define SCHM_ICU_HEADER   "SchM_Icu.h"
#define ICU_CFG_HEADER    "Icu_Cfg.h"
#define ICU_CBK_HEADER    "Icu_Cbk.h"
#endif /* defined(ICU_INSTANCE_INDEX) */
#endif /* ICU_MULTIINSTANCE_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
