/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_Types.h                                                                                         */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision of Database declaration.                                                                                 */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.3:  17/04/2022  : Merge QAC message from U2Ax, E2x and U2Bx
 * 1.4.1:  18/10/2021  : Add QAC message 9.5.0
 *         15/09/2021  : Rename pTimerChannelConfig to pChannelUserRegConfig
 *                       Correct preprocessor directives
 *                       Update Pointer to ICU driver Timer IP configuration
 * 1.3.2:  30/08/2021  : Update header file macro.
 *                       Correct included file.
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0828)    : More than 8 levels of nested conditional inclusion - program does not conform strictly to    */
/*                       ISO:C90.                                                                                     */
/* Rule                : CERTCCM DCL23, MISRA C:2012 Rule-5.4                                                         */
/* JV-01 Justification : This is accepted, , due to the implementation is following hardware specification.           */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)                                                                                       /* PRQA S 0828 # JV-01 */
        #ifndef ICU_59_INST0_TYPES_H                                                                                    /* PRQA S 0828 # JV-01 */
            #define ICU_59_INST0_TYPES_H
            #define ICU_TYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_TYPES_H                                                                                    /* PRQA S 0828 # JV-01 */
            #define ICU_59_INST1_TYPES_H
            #define ICU_TYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_TYPES_H                                                                                    /* PRQA S 0828 # JV-01 */
            #define ICU_59_INST2_TYPES_H
            #define ICU_TYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_TYPES_H                                                                                    /* PRQA S 0828 # JV-01 */
            #define ICU_59_INST3_TYPES_H
            #define ICU_TYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_TYPES_H                                                                                    /* PRQA S 0828 # JV-01 */
            #define ICU_59_INST4_TYPES_H
            #define ICU_TYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_TYPES_H                                                                                    /* PRQA S 0828 # JV-01 */
            #define ICU_59_INST5_TYPES_H
            #define ICU_TYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_TYPES_H                                                                                    /* PRQA S 0828 # JV-01 */
            #define ICU_59_INST6_TYPES_H
            #define ICU_TYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_TYPES_H                                                                                    /* PRQA S 0828 # JV-01 */
            #define ICU_59_INST7_TYPES_H
            #define ICU_TYPES_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_TYPES_H                                                                                                 /* PRQA S 0828 # JV-01 */
        #define ICU_TYPES_H
        #define ICU_TYPES_HEADER
    #endif
#endif

#ifdef ICU_TYPES_HEADER
#undef ICU_TYPES_HEADER                                                                                                 /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for pre-compile options */

/* platform specific type definitions */
#include "Std_Types.h"
/* Include definition of multi instance */
#include "Icu_MultiInstance.h"
/* Included for pre-compile options */
#include ICU_CFG_HEADER
/* Include for pointer of notification function */
#include ICU_CBK_HEADER

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define ICU_TYPES_AR_RELEASE_MAJOR_VERSION    ICU_AR_RELEASE_MAJOR_VERSION
#define ICU_TYPES_AR_RELEASE_MINOR_VERSION    ICU_AR_RELEASE_MINOR_VERSION
#define ICU_TYPES_AR_RELEASE_REVISION_VERSION ICU_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ICU_TYPES_SW_MAJOR_VERSION            ICU_SW_MAJOR_VERSION
#define ICU_TYPES_SW_MINOR_VERSION            ICU_SW_MINOR_VERSION

/**********************************************************************************************************************/

/* Data Structure for ICU for Initializing the ICU Module */
typedef struct STag_Icu_ConfigType
{
  /* Database start value */
  uint32 ulStartOfDbToc;

  /* Pointer to ICU driver channel configuration */
  P2CONST(void, TYPEDEF, ICU_CONFIG_DATA) pChannelConfig;

  /* Pointer to ICU driver channel user register configuration */
  P2CONST(void, TYPEDEF, ICU_CONFIG_DATA) pChannelUserRegConfig;

  /* Pointer to the address of internal RAM data */
  P2VAR(volatile void, TYPEDEF, ICU_CONFIG_DATA) pRamAddress;

  #if ((ICU_SIGNAL_MEASUREMENT_API == STD_ON) &&                                                                        /* PRQA S 0828 # JV-01 */\
                                                 ((ICU_ATU_TIMER_UNIT_USED == STD_ON) || (ICU_TAU_UNIT_USED == STD_ON)))
  /* Pointer to the address of Signal Measure RAM data */
  P2VAR(volatile void, TYPEDEF, ICU_CONFIG_DATA) pSignalMeasureAddress;
  #endif

  #if ((ICU_TIMESTAMP_API == STD_ON) && ((ICU_ATU_TIMER_UNIT_USED == STD_ON) || (ICU_TAU_UNIT_USED == STD_ON)))         /* PRQA S 0828 # JV-01 */
  /* Pointer to the address of TimeStamp RAM data */
  P2VAR(volatile void, TYPEDEF, ICU_CONFIG_DATA) pTimeStampAddress;
  #endif

  #if ((ICU_EDGE_COUNT_API == STD_ON) && ((ICU_ATU_TIMER_UNIT_USED == STD_ON) || (ICU_TAUD_UNIT_USED == STD_ON)))       /* PRQA S 0828 # JV-01 */
  /* Pointer to the address of Edge Count RAM data */
  P2VAR(volatile void, TYPEDEF, ICU_CONFIG_DATA) pEdgeCountRamAddress;
  #endif

  #if (ICU_TAU_UNIT_USED == STD_ON)                                                                                     /* PRQA S 0828 # JV-01 */
  /* Pointer to ICU driver TAU configuration */
  P2CONST(void, TYPEDEF, ICU_CONFIG_DATA) pTAUUnitConfig;
  #endif /* End of (ICU_TAU_UNIT_USED == STD_ON) */
  
  #if (ICU_ATU_TIMER_UNIT_USED == STD_ON)                                                                               /* PRQA S 0828 # JV-01 */
  /* Pointer to ICU driver ATU configuration */
  P2CONST(void, TYPEDEF, ICU_CONFIG_DATA) pATUConfig;
  #endif /* End of (ICU_ATU_TIMER_UNIT_USED == STD_ON) */
} Icu_ConfigType;

/* Operation Mode of the ICU Module */
typedef enum ETag_Icu_ModeType
{
  ICU_MODE_NORMAL,
  ICU_MODE_SLEEP
} Icu_ModeType;

typedef struct STag_Icu_HWIPType
{
  /* Pointer to GPT driver Timer Unit configuration */
  VAR(uint8, ICU_CONFIG_DATA) ucIndex;
} Icu_HWIPType;

#endif /* ICU_TYPES_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
