/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Lin_Ram.c                                                                                           */
/* SW-VERSION   = 1.5.0                                                                                               */
/* Reference    = LIN_DFD_GLB_001                                                                                     */
/* Reference    = LIN_DFD_PTT_001                                                                                     */
/* Reference    = LIN_DFD_PTT_002                                                                                     */
/* Reference    = LIN_DFD_PTT_003                                                                                     */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2019-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Global variable definitions.                                                                                       */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 *
 * 1.4.3:  14/04/2022  : Update SW-VERSION to 1.4.3
 * 1.3.2:  04/03/2022  : Update SW-VERSION to 1.4.2
 * 1.3.1:  02/07/2021  : Format source code to 120 characters.
 *                       Improve Violation tag (remove START/END).
 * 1.2.0:  26/08/2020  : Release.
 * 1.1.0:  19/06/2020  : Release.
 * 1.0.1:  25/03/2020  : Update Format dd/mm/yyyy and revision format.
 * 1.0.0:  12/03/2019  : Initial Version.
 *
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Lin APIs header file */
#include "Lin.h"
/* Global RAM variables header file */
#include "Lin_Ram.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define LIN_RAM_C_AR_RELEASE_MAJOR_VERSION    LIN_AR_RELEASE_MAJOR_VERSION_VALUE
#define LIN_RAM_C_AR_RELEASE_MINOR_VERSION    LIN_AR_RELEASE_MINOR_VERSION_VALUE
#define LIN_RAM_C_AR_RELEASE_REVISION_VERSION LIN_AR_RELEASE_REVISION_VERSION_VALUE

/* File version information */
#define LIN_RAM_C_SW_MAJOR_VERSION            LIN_SW_MAJOR_VERSION_VALUE
#define LIN_RAM_C_SW_MINOR_VERSION            LIN_SW_MINOR_VERSION_VALUE

/***********************************************************************************************************************
**                                                   Version Check                                                    **
***********************************************************************************************************************/
#if (LIN_RAM_AR_RELEASE_MAJOR_VERSION != LIN_RAM_C_AR_RELEASE_MAJOR_VERSION)
  #error "Lin_Ram.c : Mismatch in Release Major Version"
#endif

#if (LIN_RAM_AR_RELEASE_MINOR_VERSION != LIN_RAM_C_AR_RELEASE_MINOR_VERSION)
  #error "Lin_Ram.c : Mismatch in Release Minor Version"
#endif

#if (LIN_RAM_AR_RELEASE_REVISION_VERSION != LIN_RAM_C_AR_RELEASE_REVISION_VERSION)
  #error "Lin_Ram.c : Mismatch in Release Revision Version"
#endif

#if (LIN_RAM_SW_MAJOR_VERSION != LIN_RAM_C_SW_MAJOR_VERSION)
  #error "Lin_Ram.c : Mismatch in Software Major Version"
#endif

#if (LIN_RAM_SW_MINOR_VERSION != LIN_RAM_C_SW_MINOR_VERSION)
  #error "Lin_Ram.c : Mismatch in Software Minor Version"
#endif

/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (1:1533)    : The object '%1s' is only referenced by function '%2s'.                                       */
/* Rule                : MISRA C:2012 Rule-8.9                                                                        */
/* JV-01 Justification : This is accepted, due to the object is defined in separated source C file to followed        */
/*                       coding rule.                                                                                 */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    Global Data                                                     **
***********************************************************************************************************************/
#define LIN_START_SEC_VAR_INIT_BOOLEAN
#include "Lin_MemMap.h"

/* Global variable to store Initialization status of LIN Driver */
volatile VAR(boolean, LIN_VAR_INIT) Lin_GblDriverState = LIN_UNINIT;                                                    /* PRQA S 1533 # JV-01 */

#define LIN_STOP_SEC_VAR_INIT_BOOLEAN
#include "Lin_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define LIN_START_SEC_VAR_NO_INIT_PTR
#include "Lin_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/* Global pointer to hold first channel data structure */
volatile P2CONST(Lin_ChannelInfo, LIN_VAR_NO_INIT, LIN_APPL_CONST) volatile Lin_GpChannelConfig;

/* Global pointer to hold first RLin3 channel data structure address */
volatile P2CONST(Lin3_ChannelConfigType, LIN_VAR_NO_INIT, LIN_APPL_CONST) volatile Lin_GpRLIN3Properties;

/* Global pointer to hold first channel RAM structure */
volatile P2VAR(Lin_RamData, LIN_VAR_NO_INIT, LIN_APPL_DATA) volatile Lin_GpChannelRamData;                              /* PRQA S 3432 # JV-01 */

#define LIN_STOP_SEC_VAR_NO_INIT_PTR
#include "Lin_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/***********************************************************************************************************************
**                                                Function Definitions                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
