/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi_LTTypes.h                                                                                       */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains the type definitions for link time parameters                                                   */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/* 1.4.2:  02/03/2022  : Merge QAC
 * 1.3.2:  06/09/2021  : Update QAC contents
 *         30/08/2021  : Update header file macro to call file multiple times
 * 1.3.1:  02/07/2021  : Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  30/07/2020  : Release
 *         28/07/2020  : Add QAC 9.3.1 comment.
 * 1.1.0:  19/06/2020  : Release
 * 1.0.1:  14/04/2020  : Add usTxChannelOffset in Spi_HWStatusType
 * 1.0.0:  24/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

#ifdef SPI_INSTANCE_INDEX
    #if (SPI_INSTANCE_INDEX == 0)
        #ifndef SPI_59_INST0_LTTYPES_H
            #define SPI_59_INST0_LTTYPES_H
            #define SPI_LTTYPES_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 1)
        #ifndef SPI_59_INST1_LTTYPES_H
            #define SPI_59_INST1_LTTYPES_H
            #define SPI_LTTYPES_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 2)
        #ifndef SPI_59_INST2_LTTYPES_H
            #define SPI_59_INST2_LTTYPES_H
            #define SPI_LTTYPES_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 3)
        #ifndef SPI_59_INST3_LTTYPES_H
            #define SPI_59_INST3_LTTYPES_H
            #define SPI_LTTYPES_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 4)
        #ifndef SPI_59_INST4_LTTYPES_H
            #define SPI_59_INST4_LTTYPES_H
            #define SPI_LTTYPES_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 5)
        #ifndef SPI_59_INST5_LTTYPES_H
            #define SPI_59_INST5_LTTYPES_H
            #define SPI_LTTYPES_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 6)
        #ifndef SPI_59_INST6_LTTYPES_H
            #define SPI_59_INST6_LTTYPES_H
            #define SPI_LTTYPES_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 7)
        #ifndef SPI_59_INST7_LTTYPES_H
            #define SPI_59_INST7_LTTYPES_H
            #define SPI_LTTYPES_HEADER
        #endif
    #else
        #error "Miss instance index"
    #endif
#else
    #ifndef SPI_LTTYPES_H
        #define SPI_LTTYPES_H
        #define SPI_LTTYPES_HEADER
    #endif
#endif

#ifdef SPI_LTTYPES_HEADER
#undef SPI_LTTYPES_HEADER                                                                                               /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_AR_RELEASE_MAJOR_VERSION
#define SPI_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_AR_RELEASE_MINOR_VERSION
#define SPI_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_AR_RELEASE_REVISION_VERSION

/* File version information */
#define SPI_LTTYPES_SW_MAJOR_VERSION            SPI_SW_MAJOR_VERSION
#define SPI_LTTYPES_SW_MINOR_VERSION            SPI_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
#define SPI_DBTOC_VALUE                                                                  \
  (uint32)(((uint32)SPI_VENDOR_ID_VALUE << 22U) | ((uint32)SPI_MODULE_ID_VALUE << 14U) | \
           ((uint32)SPI_SW_MAJOR_VERSION_VALUE << 8U) | ((uint32)SPI_SW_MINOR_VERSION_VALUE << 3U))

#define SPI_TRUE            (boolean)1
#define SPI_FALSE           (boolean)0
#define SPI_MAX_PRIORITY    (uint8)0x03
#define SPI_INVALID_DMAUNIT (uint8)0xFF

/* Structure for storing external buffer attributes */
typedef struct STag_Spi_EBDataType
{
  /* Pointer to external buffer source data */
  P2CONST(Spi_DataBufferType, TYPEDEF, SPI_APPL_DATA) pSrcPtr;
  /* Pointer to external buffer destination data */
  P2VAR(Spi_DataBufferType, TYPEDEF, SPI_APPL_DATA) pDestPtr;                                                           /* PRQA S 3432 # JV-01 */
  /* Length of external buffer */
  Spi_NumberOfDataType usEBLength;
} Spi_EBDataType;

/* Structure for the status for each HW unit */
typedef struct STag_Spi_HWStatusType
{
  #if (SPI_HW_STATUS_API == STD_ON)
  /* Whether this HWUnit is active */
  boolean blActive;
  #endif
  /* Index of Sequence which is going on this HWUnit */
  Spi_SequenceType ucOngoingSeqIndex;
  /* Index of Job which is going on this HWUnit */
  Spi_JobType usOngoingJobIndex;
  /* Index of Channel which should be accessed at the next transmission */
  Spi_ChannelType ucTxChannelCount;
  /* Index of Channel which should be accessed at the next reception */
  Spi_ChannelType ucRxChannelCount;
  /* Number of remained tx data elements of the current Channel */
  Spi_NumberOfDataType usRemainedTxCount;
  /* Number of remained rx data elements of the current Channel */
  Spi_NumberOfDataType usRemainedRxCount;
  #if ((STD_ON == SPI_MSPI_CONFIGURED) && (STD_ON == SPI_FIXED_BUFFER_MODE))
  /* Offset of Channel in MSPI RAM to start transmission */
  Spi_NumberOfDataType usTxChannelOffset;
  #endif
  /* Pointer to tx buffer */
  volatile P2CONST(Spi_DataBufferType, TYPEDEF, SPI_APPL_DATA) pTxPtr;
  /* Pointer to rx buffer */
  volatile P2VAR(Spi_DataBufferType, TYPEDEF, SPI_APPL_DATA) pRxPtr;                                                    /* PRQA S 3432 # JV-01 */
} Spi_HWStatusType;

/***********************************************************************************************************************
**                                        Extern declarations for Global Data                                         **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                             Global Function Prototypes                                             **
***********************************************************************************************************************/

#endif /* SPI_LTTYPES_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
