/*============================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                         */
/* Module       = EthSwt_Types.h                                              */
/* SW-VERSION   = 1.6.0                                                       */
/*============================================================================*/
/*                                  COPYRIGHT                                 */
/*============================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.        */
/*============================================================================*/
/* Purpose:                                                                   */
/* This file is a stub for EthSwt component.                                  */
/*============================================================================*/
/*                                                                            */
/* Unless otherwise agreed upon in writing between your company and           */
/* Renesas Electronics Corporation the following shall apply!                 */
/*                                                                            */
/* Warranty Disclaimer                                                        */
/*                                                                            */
/* There is no warranty of any kind whatsoever granted by Renesas. Any        */
/* warranty is expressly disclaimed and excluded by Renesas, either expressed */
/* or implied, including but not limited to those for non-infringement of     */
/* intellectual property, merchantability and/or fitness for the particular   */
/* purpose.                                                                   */
/*                                                                            */
/* Renesas shall not have any obligation to maintain, service or provide bug  */
/* fixes for the supplied Product(s) and/or the Application.                  */
/*                                                                            */
/* Each User is solely responsible for determining the appropriateness of     */
/* using the Product(s) and assumes all risks associated with its exercise    */
/* of rights under this Agreement, including, but not limited to the risks    */
/* and costs of program errors, compliance with applicable laws, damage to    */
/* or loss of data, programs or equipment, and unavailability or              */
/* interruption of operations.                                                */
/*                                                                            */
/* Limitation of Liability                                                    */
/*                                                                            */
/* In no event shall Renesas be liable to the User for any incidental,        */
/* consequential, indirect, or punitive damage (including but not limited     */
/* to lost profits) regardless of whether such liability is based on breach   */
/* of contract, tort, strict liability, breach of warranties, failure of      */
/* essential purpose or otherwise and even if advised of the possibility of   */
/* such damages. Renesas shall not be liable for any services or products     */
/* provided by third party vendors, developers or consultants identified or   */
/* referred to the User by Renesas in connection with the Product(s) and/or   */
/* the Application.                                                           */
/*                                                                            */
/*============================================================================*/
/* Environment:                                                               */
/*              Devices:        X2x                                           */
/*============================================================================*/

/*******************************************************************************
**                      Revision Control History                              **
*******************************************************************************/
/*
 * 1.4.0: 26/04/2021    : Removed ETHSWT_ETHERHEADER_SIZE macro.
 *                        Added ETHSWT_SRC_DST_ADDRESS_SIZE macro.
 * 1.2.0: 13/07/2020    : Release
 * 1.1.0: 19/06/2020    : Release
 * 1.0.0: 23/03/2020    : Initial version
 */
/******************************************************************************/

#ifndef ETHSWT_TYPES_H
#define ETHSWT_TYPES_H

/*******************************************************************************
**                      Include Section                                       **
*******************************************************************************/
#include"Eth_GeneralTypes.h"

/*******************************************************************************
**                      Version Information                                   **
*******************************************************************************/

/* AUTOSAR release version information */
#define ETHSWT_TYPES_AR_RELEASE_MAJOR_VERSION      4
#define ETHSWT_TYPES_AR_RELEASE_MINOR_VERSION      3
#define ETHSWT_TYPES_AR_RELEASE_REVISION_VERSION   1

/* Module software version information */
#define ETHSWT_TYPES_SW_MAJOR_VERSION         1
#define ETHSWT_TYPES_SW_MINOR_VERSION         5

/*******************************************************************************
**                      Global Symbols                                        **
*******************************************************************************/

#define ETHSWT_MANAGEMENT_INFORMATION 8UL
#define ETHSWT_DSA_TAG_ETHER_TYPE     (uint16)0x8686U

/*******************************************************************************
**                      Global Data Types                                     **
*******************************************************************************/
typedef struct STag_EthSwt_DSATagType
{
  uint8 ucMode_SwtDev;                       /* Mode(2)/b29/Switch Device(5) */
  uint8 ucSwtPort;                           /* Switch Port/b18/b17/b16 */
  uint8 ucPRI_HVID;                          /* PRI[2:0]/b12/VID[11:8] */
  uint8 ucLVID;                              /* VID[7:0] */
} EthSwt_DSATagType;

typedef struct STag_EthSwt_EDSATagType
{
  uint16 usEtherType;                        /* Prog. DSA Ether Type */
  uint8  Reserved0[2];                       /* Reserved */
  EthSwt_DSATagType stDSA;
} EthSwt_EDSATagType;
/*******************************************************************************
**                      Function Prototypes                                   **
*******************************************************************************/

#endif /* ETHSWT_TYPES_H */

/*******************************************************************************
**                      End of File                                           **
*******************************************************************************/
