#include "Sys_Scheduler_Lib.h"


uint32_t cnt_ostm0;
uint8_t ostm_50us_flg = 0;
uint8_t ostm_2ms_flg = 0;
uint8_t ostm_5ms_flg = 0;
uint8_t ostm_10ms_flg = 0;
uint8_t ostm_20ms_flg = 0;
uint8_t ostm_50ms_flg = 0;
uint8_t ostm_100ms_flg = 0;

uint32_t sys_delay_cnt = 0;

typedef struct
{
    uint32_t u32msRocBak;
    uint32_t u32Task2msCnt;
    uint32_t u32Task5msCnt;
    uint32_t u32Task10msCnt;
    uint32_t u32Task20msCnt;
    uint32_t u32Task50msCnt;
    uint32_t u32Task100msCnt;
} Sys_Scheduler_st_t;


void Sys_Scheduler_ISR(void)
{
  /* Notification for channel */
 //Dio_FlipChannel(DioConf_DioChannel_UserChannel_02_03);
    Sys_50us_Tasks();
     cnt_ostm0++;

    ostm_50us_flg = 1;

    if (!(cnt_ostm0%40))
    {
        ostm_2ms_flg = 1;
    }

    if (!(cnt_ostm0%100))
    {
        ostm_5ms_flg = 1;
    }

    if (!(cnt_ostm0%200))
    {
        ostm_10ms_flg = 1;
    }

    if (!(cnt_ostm0%400))
    {
        ostm_20ms_flg = 1;
    }

    if (!(cnt_ostm0%1000))
    {
        ostm_50ms_flg = 1;
    }

    if (!(cnt_ostm0%2000))
    {
        ostm_100ms_flg = 1;
    }

    if (sys_delay_cnt)
    {
        sys_delay_cnt--;
    }

}

void Sys_Scheduling_Service(void)
{
    if (ostm_2ms_flg)
    {
        ostm_2ms_flg = 0;
        Sys_2ms_Tasks();
    }

    if (ostm_5ms_flg)
    {
        ostm_5ms_flg = 0;
        Sys_5ms_Tasks();
    }

    if (ostm_10ms_flg)
    {
        ostm_10ms_flg = 0;
        Sys_10ms_Tasks();
    }

    if (ostm_20ms_flg)
    {
        ostm_20ms_flg = 0;
        Sys_20ms_Tasks();
    }

    if (ostm_50ms_flg)
    {
        ostm_50ms_flg = 0;
        Sys_50ms_Tasks();
    }

    if (ostm_100ms_flg)
    {
        ostm_100ms_flg = 0;
        Sys_100ms_Tasks();
    }
}
