/*******************************************************************************
* Warranty Disclaimer :
*
* Because the Product(s) is licensed free of charge, there is no warranty of
* any kind whatsoever and expressly disclaimed and excluded by Renesas, either
* expressed or implied, including but not limited to those for non-infringement
* of intellectual property, merchantability and/or fitness for the particular
* purpose. Renesas shall not have any obligation to maintain, service or provide
* bug fixes for the supplied Product(s) and/or the Application.
*
* Each User is solely responsible for determining the appropriateness of using
* the Product(s) and assumes all risks associated with its exercise of rights
* under this Agreement, including, but not limited to the risks and costs of
* program errors, compliance with applicable laws, damage to or loss of data,
* programs or equipment, and unavailability or interruption of operations.
*
* Limitation of Liability :
*
* In no event shall Renesas be liable to the User for any incidental,
* consequential, indirect, or punitive damage (including but not limited to
* lost profits) regardless of whether such liability is based on breach of 
* contract, tort, strict liability, breach of warranties, failure of essential
* purpose or otherwise and even if advised of the possibility of such damages.
* Renesas shall not be liable for any services or products provided by third
* party vendors, developers or consultants identified or referred to the User
* by Renesas in connection with the Product(s) and/or the Application.
*
* Copyright (C) 2019 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/*******************************************************************************
* File Name	    : main_pe1.c
* Version	    : 0.01
* Device(s) 	: RH850/U2A
* Description	: This is the main_pe1 tutorial code.
********************************************************************************
* History : DD.MM.YYYY Version Description
* : 04.26.2019 0.01 First Release
*******************************************************************************/

/*******************************************************************************
header include
*******************************************************************************/
#include "device.h"
#include "Wdg.h"
#include "Wdg_WDTB_LLDriver.h"
/*******************************************************************************
Macro definitions
*******************************************************************************/
#if 1
#define PORT_PKCPROT					(* (volatile unsigned int *) 0xFFD92F40)
#define PORT_PWE						(* (volatile unsigned int *) 0xFFD92F44)
#define PORT_PCR1_0						(* (volatile unsigned int *) 0xFFD92040)
#define PORT_PCR1_1						(* (volatile unsigned int *) 0xFFD92044)
#define PORT_PCR1_2						(* (volatile unsigned int *) 0xFFD92048)
#define PORT_PCR1_3						(* (volatile unsigned int *) 0xFFD9204C)
#define PORT_PCR1_4						(* (volatile unsigned int *) 0xFFD92050)
#define PORT_PCR1_5						(* (volatile unsigned int *) 0xFFD92054)

#define SYNC_DATA						(* (volatile unsigned int *) 0xFE400004)
#endif

/*******************************************************************************
Imported global variables and functions (from other files)
*******************************************************************************/

/*******************************************************************************
Exported global variables and functions (to be accessed by other files)
*******************************************************************************/

/*******************************************************************************
* Outline      : PE1 Main processing
* Header       : 
* Function name: void main_pe1 (void)
* Description  : PE1 main routine
* Arguments    : none
* Return Value : none
*******************************************************************************/

void main_pe1()
{
#if 1
	unsigned int	i;

	SYNC_DATA |= 1 << 1;

#if 0
	while( (SYNC_DATA & 0x0000000f) != 0x0000000f );
#else
	while( (SYNC_DATA & 0x0000000f) != 0x0000000f )  __asm("snooze");
#endif

	// Port register write access enable setting
	PORT_PKCPROT = 0xA5A5A501;
	PORT_PWE     = 0x0fffffff;

	while(1)
	{
		PORT_PCR1_1 = 0x00001000;

//		for(i=0; i<1000; i++)	__asm("nop");
		for(i=0; i<10000; i++)	__asm("nop");

		PORT_PCR1_1 = 0x00000000;

//		for(i=0; i<1000; i++)	__asm("nop");
		for(i=0; i<10000; i++)	__asm("nop");
		Wdg_WDTBn_TriggerFunc();
	}
#else
    while(1);
#endif
}

/*-----<End of main_pe1.c>----------------------------------------------------*/
