#include "CAN_CH0_APP.h"
#include "CAN_CH0_Tx_Matirx.h"
#include  "CAN_CH0_CAN_Communication_Matrix.h"
#include  "CAN_CH1_CAN_Communication_Matrix.h"
// #include "dr7f702301.h"
void Can_Set_Buff_217(uint8_t CopyData [])
{
    uint8_t         i = 0u;
    CANMsg217Union *pCANMsg217;
 

    pCANMsg217 = ( CANMsg217Union * )CopyData;
    if ( pCANMsg217 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg217->Msg [ i ] = 0u;
        }
        
        pCANMsg217->Sig.RAZ_ODO_PARTIEL = 1;
        pCANMsg217->Sig.ENT_PUSH_ODO_FILTRE = 2;

        pCANMsg217->Sig.SIGNAL_DEF_AIRBAG =  1U;

        pCANMsg217->Sig.ENT_PUSH_ESP = 3;
        
        pCANMsg217->Sig.IHM_INHIB = 0U;         
        pCANMsg217->Sig.NIV_LUM = 4;              
        pCANMsg217->Sig.UNIT_DIST_CMB = 0U;      
        pCANMsg217->Sig.ENT_PUSH_AAS = 0U;         
        pCANMsg217->Sig.DMD_CHGMT_ETAT_SCP = 0U;   
        pCANMsg217->Sig.DMD_RAZM_MATT = 0U;        
        pCANMsg217->Sig.VITESSE_AFF_CMB = 5;      
        pCANMsg217->Sig.DEFAUT_AFFICHEUR = 0U;     
        pCANMsg217->Sig.RAZM = 6;                 
        pCANMsg217->Sig.DMD_CHECK_MAT = 7;    
        pCANMsg217->Sig.ENT_PUSH_DYN = 0U;     
        pCANMsg217->Sig.ENT_PUSH_DSGI = 8;        

        
    }
}
extern uint8_t g_u8cnt;

void Can_Set_Buff_317(uint8_t CopyData [])
{
    uint8_t         i = 0u;
    uint32_t u32val = 0U;
    CANMsg317Union *pCANMsg317;
 

    pCANMsg317 = ( CANMsg317Union * )CopyData;
    if ( pCANMsg317 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg317->Msg [ i ] = 0u;
        }
        u32val = (*((volatile uint32_t*)0xff9a5208UL));
        pCANMsg317->Sig.STOP_VOY=g_u8cnt;   
        // pCANMsg317->Sig.T_HUIL_VOY= (uint32_t)(*((volatile uint32_t*)0xff9a5208UL));
        // pCANMsg317->Sig.MINC_VOY=1;	
        // pCANMsg317->Sig.T_EAU_VOY=1;
        // pCANMsg317->Sig.SOUG_VOY=1;	
        // pCANMsg317->Sig.NIVL_VOY=1;	
        // pCANMsg317->Sig.ASR_DEF_VOY=1;		
        // pCANMsg317->Sig.PIED_FREIN_VOY=1;
        // pCANMsg317->Sig.PLUS_START_VOY=1;
        pCANMsg317->Msg [ 1 ] = (uint8_t)((u32val & 0xFF000000UL) >> 24); 
        pCANMsg317->Msg [ 2 ] = (uint8_t)((u32val & 0x00FF0000UL) >> 16);
        pCANMsg317->Msg [ 3 ] = (uint8_t)((u32val & 0x0000FF00UL) >> 8);
        pCANMsg317->Msg [ 4 ] = (uint8_t)((u32val & 0x000000FFUL));
        pCANMsg317->Msg [ 5 ] = 0;
        // pCANMsg317->Sig.FSE_SER_DEF_VOY=1;  
        // pCANMsg317->Sig.REF_DEF_VOY=1;    
        // pCANMsg317->Sig.CBAT_DEF_VOY=1;   
        // pCANMsg317->Sig.GENE_DEF_VOY=1;    
        // pCANMsg317->Sig.FSE_SYST_DEF_VOY=1;    
        // pCANMsg317->Sig.ABS_DEF_VOY=1;    
        // // pCANMsg317->Sig.SERVICE_VOY=1;
        // pCANMsg317->Sig.SEC_PASS_DEF_VOY=1; 
      
        // pCANMsg317->Sig.PORT_OUV_VOY = 1U;
        // pCANMsg317->Sig.FSE_INHIB_VOY = 1U;
        
    }
}

void Can_Set_Buff_31C(uint8_t CopyData [])
{
    uint8_t         i = 0u;
    CANMsg31CUnion *pCANMsg31C;
  

    pCANMsg31C = ( CANMsg31CUnion * )CopyData;
    if ( pCANMsg31C != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg31C->Msg [ i ] = 0u;
        }           
               
        pCANMsg31C->Sig.DMD_RAZ_TRAJET2_MATT = 8; 
        pCANMsg31C->Sig.DMD_RAZ_TRAJET1_MATT = 7; 
        pCANMsg31C->Sig.CHECK_MATT = 6; 

    }
}

void Can_Set_Buff_257(uint8_t CopyData [])
{
    uint8_t         i = 0u;
    CANMsg257Union *pCANMsg257;
  

    pCANMsg257 = ( CANMsg257Union * )CopyData;
    if ( pCANMsg257 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg257->Msg [ i ] = 0u;
        }
        pCANMsg257->Sig.KM_SAUV_H = ( uint16_t ) ( ( 1 >> 16 ) & 0x000000FF );  
        pCANMsg257->Sig.KM_SAUV_M = ( uint16_t ) ( ( 3 >> 8 ) & 0x000000FF );  
        pCANMsg257->Sig.KM_SAUV_L = ( uint16_t ) ( ( 2 ) & 0x000000FF );
        
        pCANMsg257->Sig.SECURE_H = ( uint16_t ) (( ( ~4) >> 16 ) & 0x000000FF );  
        pCANMsg257->Sig.SECURE_M = ( uint16_t ) (( ( ~5) >> 8 ) & 0x000000FF );  
        pCANMsg257->Sig.SECURE_L = ( uint16_t ) (( ( ~7) ) & 0x000000FF );
       
        
    }
}
/*8.21*/
void Can_Set_Buff_43C(uint8_t CopyData [])
{
    uint8_t         i = 0u;
    CANMsg43CUnion *pCANMsg43C;
 

    pCANMsg43C = ( CANMsg43CUnion * )CopyData;
    if ( pCANMsg43C != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg43C->Msg [ i ] = 0u;
        }
        pCANMsg43C->Sig.CAUSE_1 = 2;
        
    }
}
/*8.21*/
void Can_Set_Buff_254(uint8_t CopyData [])
{
    uint8_t         i = 0u;
    CANMsg254Union *pCANMsg254;
 

    pCANMsg254 = ( CANMsg254Union * )CopyData;
    if ( pCANMsg254 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg254->Msg [ i ] = 0u;
        }
        pCANMsg254->Sig.REMOTE_LOCK_UNLOCK_REQ = 4;
        pCANMsg254->Sig.REMOTE_HORN_REQUEST = 7;
        pCANMsg254->Sig.REMOTE_TURN_LIGHTS_REQ = 9;
    }
}

uint8_t volatile g_u8CAN_0F6_Count;
uint8_t volatile CAN0Msg0F6Msg[8U];
void CAN_CH0_0F6_Update(uint8_t copy[])
{
    if (g_u8CAN_0F6_Count == 0)
    {
        g_u8CAN_0F6_Count++;
    }
    CAN0Msg0F6Msg[0] = copy[0];
    CAN0Msg0F6Msg[1] = copy[1];
    CAN0Msg0F6Msg[2] = copy[2];
    CAN0Msg0F6Msg[3] = copy[3];
    CAN0Msg0F6Msg[4] = copy[4];
    CAN0Msg0F6Msg[5] = copy[5];
    CAN0Msg0F6Msg[6] = copy[6];
    CAN0Msg0F6Msg[7] = copy[7];  
}
uint8_t  CAN0Msg0F6_Byte_Get(uint8_t u8ByteSeq)
{
    return CAN0Msg0F6Msg[u8ByteSeq];
}
uint8_t CAN_CH0_0F6_Update_Get(void)
{
    uint8_t u8Ret = 0U;

    if (g_u8CAN_0F6_Count > 0u)
    {
        u8Ret = 1;
        
    }
    return u8Ret;
}
void CAN_CH0_0F6_Update_Clear(void)
{
    g_u8CAN_0F6_Count = 0U;
}

uint8_t volatile g_u8CAN_1A8_Count;
void CAN_CH0_1A8_Update(void)
{
    if (g_u8CAN_1A8_Count == 0)
    {
        g_u8CAN_1A8_Count++;
    }
}

uint8_t CAN_CH0_1A8_Update_Get(void)
{
    uint8_t u8Ret = 0U;

    if (g_u8CAN_1A8_Count > 0u)
    {
        u8Ret = 1;
        g_u8CAN_1A8_Count = 0U;
    }
    return u8Ret;
}

uint8_t volatile g_u8CAN_2AD_Count;
void CAN_CH0_2AD_Update(uint8_t copy[])
{
    if (g_u8CAN_2AD_Count == 0)
    {
        g_u8CAN_2AD_Count++;
    }  
}
uint8_t CAN_CH0_2AD_Update_Get(void)
{
    uint8_t u8Ret = 0U;

    if (g_u8CAN_2AD_Count > 0u)
    {
        u8Ret = 1;
        
    }
    return u8Ret;
}
void CAN_CH0_2AD_Update_Clear(void)
{
    g_u8CAN_2AD_Count = 0U;
}


uint8_t volatile g_u8CAN_3E7_Count;
void CAN_CH0_3E7_Update(uint8_t copy[])
{
    if (g_u8CAN_3E7_Count == 0)
    {
        g_u8CAN_3E7_Count++;
    }  
}
uint8_t CAN_CH0_3E7_Update_Get(void)
{
    uint8_t u8Ret = 0U;

    if (g_u8CAN_3E7_Count > 0u)
    {
        u8Ret = 1;
        
    }
    return u8Ret;
}
void CAN_CH0_3E7_Update_Clear(void)
{
    g_u8CAN_3E7_Count = 0U;
}


uint8_t volatile g_u8CAN_294_Count;
void CAN_CH0_294_Update(uint8_t copy[])
{
    if (g_u8CAN_294_Count == 0)
    {
        g_u8CAN_294_Count++;
    }  
}
uint8_t CAN_CH0_294_Update_Get(void)
{
    uint8_t u8Ret = 0U;

    if (g_u8CAN_294_Count > 0u)
    {
        u8Ret = 1;
        
    }
    return u8Ret;
}
void CAN_CH0_294_Update_Clear(void)
{
    g_u8CAN_294_Count = 0U;
}

uint8_t volatile g_u8CAN_036_Count;
void CAN_CH0_036_Update(uint8_t copy[])
{
    if (g_u8CAN_036_Count == 0)
    {
        g_u8CAN_036_Count++;
    }  
}
uint8_t CAN_CH0_036_Update_Get(void)
{
    uint8_t u8Ret = 0U;

    if (g_u8CAN_036_Count > 0u)
    {
        u8Ret = 1;
        
    }
    return u8Ret;
}
void CAN_CH0_036_Update_Clear(void)
{
    g_u8CAN_036_Count = 0U;
}

