#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "CAN_Message_Types.h"
#include "CAN_CH0_APP.h"
/* 2023/02/14 13:08:27 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
    {0x217ul,  100ul * 1000ul,  25ul * 1000ul, 0u, 0u, 4u, 8u, CAN_MSG_CYCLE, Can_Set_Buff_217, ( void * )0},
    {0x317ul,  100ul * 1000ul,   0ul * 1000ul, 0u, 0u, 5u, 8u, CAN_MSG_CYCLE, Can_Set_Buff_317, ( void * )0},
    {0x31Cul,  200ul * 1000ul,  25ul * 1000ul, 0u, 0u, 6u, 8u, CAN_MSG_EVENT, Can_Set_Buff_31C, ( void * )0},
    {0x257ul,  100ul * 1000ul,   0ul * 1000ul, 0u, 0u, 7u, 8u, CAN_MSG_EVENT, Can_Set_Buff_257, ( void * )0},
    {0x43Cul,  100ul * 1000ul,   0ul * 1000ul, 0u, 0u, 8u, 2u, CAN_MSG_EVENT, Can_Set_Buff_43C, ( void * )0},
    {0x254ul,  600ul * 1000ul,   0ul * 1000ul, 0u, 0u, 9u, 8u, CAN_MSG_EVENT, Can_Set_Buff_254, ( void * )0},
};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x361ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x228ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x260ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x39Cul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x3E9ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x1A1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0xB0u, 0x01u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0xF0u, 0x8Cu, 0x80u, 0x00u, 0x00u, 0x04u, 0x00u},
        {0x00u, 0x00u, 0x03u, 0x10u, 0x00u, 0x06u, 0x00u, 0x08u},
        5000ul,
        0x128ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x01u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x80u, 0x08u, 0xF2u, 0x20u, 0x00u, 0x00u, 0x40u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x168ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xE8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x476ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xA8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x1Cul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x08U, 0x00u, 0x00u, 0x00u, 0xA0u},
        {0x00u, 0x00u, 0x00u, 0x0Fu, 0x01u, 0x00u, 0x00u, 0xA0u},
        {0x00u, 0x00u, 0xC0u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x36ul,
        (( void * )0),
        (CAN_CH0_036_Update),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x7FFul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x39Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xE1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x1E7ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x1E8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x276ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xB6ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x2A0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x15Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0xFFu},
        {0x02u, 0xFFu, 0xFFu, 0xFFu, 0xFFu, 0xFFu, 0xFFu, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xF6ul,
        (( void * )0),
        (CAN_CH0_0F6_Update),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x236ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x1E1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x161ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x217ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x297ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x4B2ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x328ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x2DCul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x229ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x269ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0xFFu, 0xFFu, 0xFFu},
        {0x00u, 0x00u, 0x24u, 0x00u, 0x00u, 0xFFu, 0xFFu, 0xFFu},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x1A8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0xffu, 0xffu, 0x00u, 0x00u, 0x00u},
        {0x80u, 0x00u, 0xffu, 0xffu, 0xffu, 0xffu, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        7000ul,
        0x221ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x3E0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        7000ul,
        0x3E7ul,
        (( void * )0),
        (CAN_CH0_3E7_Update),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        8000ul,
        0x3E1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0xFFU, 0xFFU, 0xFFU, 0xFFU, 0xFFU, 0x00u, 0x00u, 0x00u},
        {0xFFU, 0xFFU, 0xFFU, 0xFFU, 0xFFU, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        7000ul,
        0x2A1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0xFFu, 0xFFu, 0xFFu, 0xFFu, 0xFFu, 0x00u, 0x00u, 0x00u},
        {0xFFu, 0xFFu, 0xFFu, 0xFFu, 0xFFu, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x261ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        7000ul,
        0x169ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x1E9ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x672ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x772ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x532ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x5F2ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0xFFu, 0x00u, 0x00u, 0x00u, 0x00u},
        7000ul,
        0xA2ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x227ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x317ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x49Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xE6ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x257ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x65Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x75Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x51Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x5DFul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x5E0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x137ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x2ADul,
        (( void * )0),
        (CAN_CH0_2AD_Update),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        3000ul,
        0x350ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x294ul,
        (( void * )0),
        (CAN_CH0_294_Update),
        (( void * )0),
    },
    };

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_DSG_IND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_IRC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_DSG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 3u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_XVV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_TCFG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_SER_FSE_AUTO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_HARMONIE_SON(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_AAS_INHIB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_ESSUI_MAR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 1u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_FOLLOW(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 1u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_ACCUEIL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 1u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_MOT_VOL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 1u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_SELEC_OUV_AR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 1u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_SELEC_OUV_CLE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 1u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_SELEC_OUV_CAB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_DISPO_INFO_MENU(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_AUTOROUTE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_ECL_DECONDA(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_ECL_ADAPT_O(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_SAM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PRES_AMBIANCE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_PHARE_AUTO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_361_Sig_FEUX_DIURN_O(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_228_Sig_TENT_ACT_LVV_RVV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_228_Sig_XVV_DISPONIBLE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_228_Sig_XVV_REGL_CONS_VIT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_228_Sig_VIT_CONS_LVV_RVV(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_228_Sig_ETAT_FONCT_LVV_RVV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count, 2u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_228_Sig_FONCT_ACT_LVV_RVV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_REINIT_DSG_STATUS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 5u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_AAS_STATUS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_SAM_STATUS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_ESSUI_VIT_MAR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_FCT_MOT_VOL_AR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 4u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_FCT_TCFG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 4u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_ECLAIRAGE_ACCOM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_TEMPO_EXT_PHARE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 3u) >> 5u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_ECL_AUTOROUTE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_ECL_DECONDA(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_TEMPO_ECL_DECONDA(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 3u) >> 1u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_ECLAIRAGE_AUTO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_SER_FSE_AUTO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_SELEC_OUV_PLIP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_SELEC_CABINE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_SELEC_ARRIERE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_ACCUEIL_COND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_ECL_ADAPT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_FCT_FEUX_DIURN_O(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_ECLAI_AMBI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_UNITE_VOLUME(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_UNITE_TEMPERATURE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 1u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_DISPO_PARAM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 1u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_HARMONIE_SON(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_DISPO_UNITES_LANGUE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_LANGUE_VHL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 0u) >> 2u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_UNITE_DISTANCE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_260_Sig_UNITE_CONSO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_39C_Sig_ACK_SEGMENTATION(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACK_EXPORT_AUDIO_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_3E9_Sig_ACK_SEGMENTATION(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACK_EXPORT_NAV_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_1A1_Sig_PARAM_PTR(void)
{    

    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 4u) >> 0u) & 0xFFu));
    // return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    // ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    // ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    // ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    // ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1A1_Sig_MEDIA1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1A1_Sig_INTERD_PHASE_DEM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1A1_Sig_CHECK_COURS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1A1_Sig_PRIORITE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 2u) >> 0u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_1A1_Sig_POINT_MESS(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 0u) >> 0u) & 0x7Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1A1_Sig_NOUV_MESS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_PIED_EMBR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 7u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_MINC_CLIG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 7u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_READY_HY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 7u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARG_CLIG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 6u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 6u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARM_CLIG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 6u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARD_CLIG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 6u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_ON_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 6u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_MINC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 5u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 5u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCC_CLIG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 5u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 5u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCP_CLIG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 5u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_DMD_ALLUM_SCR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 5u) >> 1u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUCARG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 5u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_PRE_CHAUFF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_OUVRANT_OUVERT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_ESPI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 4u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_ESPACT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_SERVICE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_STOP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 3u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_ABPI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_PIED_FREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_FRPK(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 3u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_FSE_INHIB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_POS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_CROIS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_ROUTE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_ABAV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_FEUX_ABAR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_CLIGNO_D(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_CLIGNO_G(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_TYPE_ALLUM_FLECHE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_MODE_BVA_BVMP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 2u) >> 4u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_ALLUM_FLECHE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_SEL_BVA_BVM_BVMP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_RAP_AFF_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 1u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_RAP_AFF_DRIVE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 1u) >> 1u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_128_Sig_AFF_RAP_CLIGN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_ASS_DIR_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 4u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_DMD_ALLUMAGE_FA(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 7u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_DA_DEF_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 5u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_UB_DA_DEF_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 5u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_DA_DEF_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 5u) >> 3u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_UB_DA_DEF_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 5u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_CODE_VIR_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_SEC_PASS_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_DMD_ALLUM_STT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_FSE_SYST_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_FSE_SER_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 3u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_ABS_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 3u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_ASR_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_BV_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_EOBD_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 3u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_REF_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_CBAT_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_GENE_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_SOUG_AL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_POLL_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 1u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_ESSUI_AUTO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 1u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_VOY_PLUS_START(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_ALERTE_T_EAU(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_PHUI_AL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_NIVL_AL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_DSG_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_168_Sig_NIVH_AL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_0E8_Sig_GMP_TORQUE_INST(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count, 4u) >> 0u) & 0xFFu) << 1u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count, 5u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E8_Sig_GMP_TORQUE_PCT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count, 5u) >> 0u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_0E8_Sig_GMP_BOOST_PCT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count, 3u) >> 0u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_0E8_Sig_GMP_BOOST_INST(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count, 2u) >> 2u) & 0x3Fu));
}

uint16_t Get_CAN_CH0_ID_0E8_Sig_GMP_POWER_INST(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count, 0u) >> 0u) & 0xFFu) << 1u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E8_Sig_GMP_POWER_PCT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count, 1u) >> 0u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_476_Sig_REP_UCE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ACK_EVT_DEF_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_ACCEL_LONG_INST(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg_Count, 3u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_ACCEL_LAT_PCT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg_Count, 2u) >> 1u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_ACCEL_LONG_PCT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg_Count, 1u) >> 1u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_DMD_PG_TELE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A8_Sig_GMP_ACCEL_LAT_INST(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg_Count, 0u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_VITESSE_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_DISPO_INFO_XVV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_MENU_XVV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_BUTEE_5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_01C_Sig_SEL_HOR_PRECOND(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 0u) >> 0u) & 0x0Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_DISPO_PRECOND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_DMD_TYPE_PRECOND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_01C_Sig_DMD_ACTIV_PRECOND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_RESYNC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_SECU_ETAT_SEV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 7u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_PRES_MENU_PRECOND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 6u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_MODE_HY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 5u) >> 1u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_DEM_EFFAC_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 5u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_DIAG_MUX_ON(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_INTERD_MEMO_DEF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 4u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_PHASE_VIE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_TYPE_RHEOS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 3u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_ETAT_JN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 3u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_BCK_PNL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_036_Sig_LUMINOSITE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count, 3u) >> 0u) & 0x0Fu));
}

uint64_t Get_CAN_CH0_ID_7FF_Sig_BLOC_UDS(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_39B_Sig_MINUTE_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg_Count, 4u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_39B_Sig_HEURE_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg_Count, 3u) >> 0u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_39B_Sig_JOUR_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg_Count, 2u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_39B_Sig_MOIS_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg_Count, 1u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_39B_Sig_MODE_HEURE_CLIENT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_39B_Sig_ANNEE_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg_Count, 0u) >> 0u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_0E1_Sig_RETOUR_ETAT_SCP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_AVM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count, 5u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_AVD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count, 5u) >> 2u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_0E1_Sig_DMDE_AFFICHAGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count, 5u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_ARD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count, 4u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_AVG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count, 4u) >> 2u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_ARG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count, 3u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_0E1_Sig_DIST_ARM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count, 3u) >> 2u) & 0x07u));
}

uint16_t Get_CAN_CH0_ID_1E7_Sig_PUISS_PTRAC(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 3u) >> 0u) & 0x01u) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E7_Sig_TIV_CIBLE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E7_Sig_TIV_CONSIGNE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E7_Sig_ETAT_SELEC_ARTIV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_1E7_Sig_ETAT_IHM_ARTIV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_1E7_Sig_ALRT_ARTIV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E7_Sig_REGL_ALRT_ARTIV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E7_Sig_CIBLE_DETECTEE_ARTIV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count, 0u) >> 1u) & 0x01u));
}


uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_VITESSE_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_DISPO_INFO_XVV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_MENU_XV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_DMD_RAPPEL_XVV_PROG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_BUTEE_5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_1E8_Sig_HOR_PRECOND(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 0u) >> 0u) & 0x0Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_TYPE_PRECOND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E8_Sig_ACTIV_PRECOND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_276_Sig_AUTONOMIE_UREE(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 5u) >> 0u) & 0x3Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_276_Sig_MINUTE_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 4u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_276_Sig_HEURE_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 3u) >> 0u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_276_Sig_JOUR_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 2u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_276_Sig_AFFICHAGE_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 1u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_276_Sig_MOIS_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 1u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_276_Sig_MODE_HEURE_CLIENT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_276_Sig_ANNEE_HORLOGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count, 0u) >> 0u) & 0x7Fu));
}

uint16_t Get_CAN_CH0_ID_0B6_Sig_VITM(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0B6_Sig_SECU_VITESSE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg_Count, 7u) >> 3u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_0B6_Sig_VITV(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_2A0_Sig_DMD_PROG_TCFG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_TCFG_DMD_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_DMD_INIT_DSG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 5u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_AAS_STATUS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_SAM_STATUS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_ESSUI_VIT_MAR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_FCT_MOT_VOL_AR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 4u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_FCT_TCFG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 4u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_ECLAIRAGE_ACCOM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_TEMPO_EXT_PHARE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 3u) >> 5u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_ECL_AUTOROUTE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_ECL_DECONDA(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_TEMPO_ECL_DECONDA(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 3u) >> 1u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_ECLAIRAGE_AUTO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_SER_FSE_AUTO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_SELEC_OUV_PLIP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_SELEC_CABINE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_SELEC_ARRIERE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_ACCUEIL_COND(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_ECL_ADAPT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_FCT_FEUX_DIURN_O(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_ECLAI_AMBI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_UNITE_VOLUME(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_UNITE_TEMPERATURE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 1u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_DISPO_PARAM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 1u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_HARMONIE_SON(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_DISPO_UNITES_LANGUE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_LANGUE_VHL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 0u) >> 2u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_UNITE_DISTANCE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_15B_Sig_UNITE_CONSO(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0F6_Sig_TEAU(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0F6_Sig_T_EXT_FILT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_0F6_Sig_KM_TOTAL(void)
{    
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count, 2u) >> 0u) & 0xFFu) << 16u)) + \
    (((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0F6_Sig_ETAT_PRINCIP_SEV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count, 0u) >> 3u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0F6_Sig_ETAT_GMP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_236_Sig_COMPTEUR_RAZ_GCT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_236_Sig_CTX_JDD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count, 5u) >> 0u) & 0x1Fu));
}

uint32_t Get_CAN_CH0_ID_236_Sig_CPT_TEMPOREL(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_236_Sig_ETAT_RESEAU_ELEC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_236_Sig_MODE_CONFIG_VHL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_ROUE_ARD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg_Count, 3u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_DSG_GENERAL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg_Count, 3u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_ROUE_ARG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg_Count, 2u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_ROUE_AVD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg_Count, 1u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_1E1_Sig_ETAT_ROUE_AVG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg_Count, 0u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_161_Sig_NIV_CRB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_BSI_TEMP_NIVEAU_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_161_Sig_NIV_HUILE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_BSI_TEMP_NIVEAU_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_161_Sig_T_HUILE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_BSI_TEMP_NIVEAU_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_SIGNAL_DEF_AIRBAG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_DYN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 6u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_DEFAUT_AFFICHEUR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_DMD_CHGMT_ETAT_SCP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_DSGI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_AAS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_ESP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_RAZ_ODO_PARTIEL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 1u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_NIV_LUM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_RAZM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_IHM_INHIB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_VITESSE_AFF_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_DMD_RAZM_MATT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 4u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_DMD_CHECK_MAT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_ENT_PUSH_ODO_FILTRE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_217_Sig_UNIT_DIST_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_297_Sig_ACTIV_VTH(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_ETAT_VTH_Msg_Count, 0u) >> 3u) & 0x03u));
}

uint64_t Get_CAN_CH0_ID_4B2_Sig_BLOC_DIAG(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 0u) >> 0u) & 0x0Fu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_4B2_Sig_NB_TRAME(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_4B2_Sig_NUM_TRAME(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint64_t Get_CAN_CH0_ID_328_Sig_DATA_CF_EXPORT_AUDIO(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_328_Sig_NPCI_HEADER(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_328_Sig_SN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_2DC_Sig_STMIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_FC_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_2DC_Sig_BS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_FC_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_2DC_Sig_NPCI_HEADER(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_FC_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_2DC_Sig_FS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_AUDIO_FC_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint64_t Get_CAN_CH0_ID_229_Sig_DATA_CF_EXPORT_NAV(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_229_Sig_NPCI_HEADER(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_229_Sig_SN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_269_Sig_STMIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_FC_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_269_Sig_BS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_FC_Msg_Count, 1u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_269_Sig_NPCI_HEADER(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_FC_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_269_Sig_FS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EXPORT_NAV_FC_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint32_t Get_CAN_CH0_ID_1A8_Sig_ODO_PARTIEL(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 5u) >> 0u) & 0xFFu) << 16u)) + \
    (((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_1A8_Sig_XVV_BUTEE_SUP(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_1A8_Sig_XVV_BUTEE_INF(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1A8_Sig_XVV_PREPROG_ACTIF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1A8_Sig_XVV_BUTEE_ATTEINTE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_221_Sig_AUTONOMIE(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_221_Sig_CONSO_INSTANTANEE(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_221_Sig_CONSO_ODB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_221_Sig_AUTON_ODB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_221_Sig_POUSSOIR_ODB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3E0_Sig_SOC_BATT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_HYBRIDE_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_3E7_Sig_AFF_MAINT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_3E7_Sig_K_MAINT(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_3E7_Sig_NB_JOUR_MAINTENANCE(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count, 1u) >> 0u) & 0x0Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_3E7_Sig_PICTO_CLE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3E7_Sig_SIGN_MAINT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3E7_Sig_SIGN_ECHEANCE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3E1_Sig_RECHARGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_3E1_Sig_DISPO_FCT_STT_HY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_3E1_Sig_DMD_ZERO_EMISSION(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3E1_Sig_ETAT_MTH(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_3E1_Sig_ETAT_ME(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_3E1_Sig_CPT_STOP_HEURE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_3E1_Sig_CPT_STOP_MINUTE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count, 0u) >> 0u) & 0x3Fu));
}

uint16_t Get_CAN_CH0_ID_2A1_Sig_CONSO_TRAJET1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_2A1_Sig_DISTANCE_TRAJET1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_2A1_Sig_VITESSE_MOYENNE_T1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_261_Sig_CONSO_TRAJET2(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_261_Sig_DISTANCE_TRAJET2(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_261_Sig_VITESSE_MOYENNE_T2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_169_Sig_DISTANCE_PRECONS(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_Msg_Count, 5u) >> 0u) & 0xFFu) << 5u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_Msg_Count, 6u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_169_Sig_ETAT_NAV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_169_Sig_ETAT_CALCUL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_169_Sig_NUM_PICTO_PRECONS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_Msg_Count, 0u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_1E9_Sig_PICTO_POI_RADAR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_2_Msg_Count, 2u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_1E9_Sig_DISPO_AFF_VIT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_2_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_1E9_Sig_VITESSE_CONSEIL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_2_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_1E9_Sig_VITESSE_LIMITE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_INFO_NAV_2_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint64_t Get_CAN_CH0_ID_672_Sig_DATA_DIAG(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint64_t Get_CAN_CH0_ID_772_Sig_DATA_DIAG(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_532_Sig_UCE_ABS_MATT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_532_Sig_C_DEFAUT_PERTE_COM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_532_Sig_C_DEFAUT_BUSOFF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_532_Sig_C_DEFAUT_N_AS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_532_Sig_C_DEFAUT_NERR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_532_Sig_PERTE_COM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_532_Sig_BIT_NERR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_532_Sig_ETAT_NM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_5F2_Sig_NUM_EDITION(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_MATT_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5F2_Sig_DIGIT_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_MATT_Msg_Count, 6u) >> 4u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_5F2_Sig_IDENT_LOGIC(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_MATT_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_MATT_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5F2_Sig_VER_LOG_ANNEE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_MATT_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5F2_Sig_VER_LOG_MOIS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_MATT_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5F2_Sig_VER_LOG_JOUR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_MATT_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5F2_Sig_NUM_UCE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_MATT_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0A2_Sig_OVF_NAV_SUP_ET_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VMF_DSGN_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A2_Sig_OVF_NAV_INF_ET_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VMF_DSGN_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A2_Sig_VALID_ET_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VMF_DSGN_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A2_Sig_ESCAPE_ET_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VMF_DSGN_Msg_Count, 4u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A2_Sig_CMPT_NAV_MENU_CMB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VMF_DSGN_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_PUSH_SAM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_LED_PUSH_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_LED_DYN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_LED_PUSH_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_PUSH_FREIN_SEC_ELE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_LED_PUSH_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_PUSH_AAS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_LED_PUSH_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_227_Sig_SORTIE_PUSH_ESP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_LED_PUSH_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_SEC_PASS_DEF_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_CBAT_DEF_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 4u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_ABS_DEF_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_ASR_DEF_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 3u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_PLUS_START_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_FSE_SYST_DEF_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 3u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_FSE_SER_DEF_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 3u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_PIED_FREIN_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_NIVL_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_SOUG_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_REF_DEF_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_PORT_OUV_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_GENE_DEF_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 1u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_T_EAU_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 1u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_T_HUIL_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 1u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_ABPI_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_MINC_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_SERVICE_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_317_Sig_STOP_VOY(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint64_t Get_CAN_CH0_ID_49F_Sig_BLOC_DIAG(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 0u) >> 0u) & 0x0Fu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_49F_Sig_NB_TRAME(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_49F_Sig_NUM_TRAME(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_CPT_PROCESS_4B_UC_FREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 7u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_CHKSUM_TRME_DAT_UC_FREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 7u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_FNCT_SFU_UC_FREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 6u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_DEFAUT_GEE_UCFREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 6u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_BES_FREIN_STT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 6u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_TENSION_BATTERIE_UCFREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0E6_Sig_CPT_TOP_ARD(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 3u) >> 0u) & 0x7Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_DEFAUT_CMPT_TOPS_ARD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_0E6_Sig_CPT_TOP_ARG(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 1u) >> 0u) & 0x7Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_DEFAUT_CMPT_TOPS_ARG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 1u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_REQ_LAMPE_DEF_REF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_REGUL_ABR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_FNCT_AAFD_UC_FREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_REGUL_REF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_USURE_PLAQ_FREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_ALRT_LIQU_FREIN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0E6_Sig_REQ_LAMPE_DEF_ABR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint32_t Get_CAN_CH0_ID_257_Sig_SECURE(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_KM_SAUV_CMB_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_KM_SAUV_CMB_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_KM_SAUV_CMB_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_257_Sig_KM_SAUV(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_KM_SAUV_CMB_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_KM_SAUV_CMB_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_KM_SAUV_CMB_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint64_t Get_CAN_CH0_ID_65F_Sig_DATA_DIAG(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint64_t Get_CAN_CH0_ID_75F_Sig_DATA_DIAG(void)
{
    return (((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint64_t)((uint64_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_UCE_ABS_CMB_3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_UCE_ABS_CMB_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_UCE_ABS_CMB_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_C_DEFAUT_PERTE_COM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_C_DEFAUT_BUSOFF(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_C_DEFAUT_N_AS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_C_DEFAUT_NERR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_PERTE_COM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_BIT_NERR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_51F_Sig_ETAT_NM(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_5DF_Sig_NUM_EDITION(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5DF_Sig_DIGIT_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 6u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_5DF_Sig_DIGIT_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_5DF_Sig_IDENT_LOGIC(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5DF_Sig_VER_LOG_ANNEE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5DF_Sig_VER_LOG_MOIS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5DF_Sig_VER_LOG_JOUR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5DF_Sig_NUM_UCE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_VERSION_CMB_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_5E0_Sig_EDR_Full(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EDR_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_5E0_Sig_EDR_Fault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_EDR_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_137_Sig_EGS_Fault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EGS_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_2AD_Sig_EXTINCTION_LCD_CONDA(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID_CDE_IHM_CLIM_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_350_Sig_TYPAGE(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 0u) >> 0u) & 0x03u));
}
uint8_t  Get_CAN_CH0_ID_350_Sig_DMD_AC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 0u) >> 2u) & 0x03u));
}
uint8_t  Get_CAN_CH0_ID_350_Sig_DMD_VISI(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 0u) >> 4u) & 0x01u));
}
uint8_t  Get_CAN_CH0_ID_350_Sig_VAL_CONS_TEMP_AVG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 3u) >> 0u) & 0x1Fu));
}
uint8_t  Get_CAN_CH0_ID_350_Sig_VAL_CONS_TEMP_AVD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 4u) >> 0u) & 0x1Fu));
}
uint8_t  Get_CAN_CH0_ID_350_Sig_PULS_AV(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 5u) >> 0u) & 0x0Fu));
}
uint8_t  Get_CAN_CH0_ID_350_Sig_ENTREE_AIR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 5u) >> 4u) & 0x0Fu));
}
uint8_t  Get_CAN_CH0_ID_350_Sig_DISTRIBUTION_AVD(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 6u) >> 0u) & 0x0Fu));
}
uint8_t  Get_CAN_CH0_ID_350_Sig_DISTRIBUTION_AVG(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_350_Msg_Count, 6u) >> 4u) & 0x0Fu));
}
uint8_t  Get_CAN_CH0_ID_294_Sig_TURN_LIGHTS_STATUS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID294_REMOTE_ACTION_REP_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_294_Sig_HORN_STATUS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID294_REMOTE_ACTION_REP_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_294_Sig_REMOTE_LOCK_UNLOCK_STAT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ID294_REMOTE_ACTION_REP_Msg_Count, 0u) >> 1u) & 0x03u));
}

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_ID_BSI_INF_CFG_Msg:
        u8Result = CAN_CH0_ID_ID_BSI_INF_CFG_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg:
        u8Result = CAN_CH0_ID_ID_ACC_XVV_IHM_ETAT_Msg_Count;
        break;
    case CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg:
        u8Result = CAN_CH0_ID_ID_BSI_INF_PROFILS_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ACK_EXPORT_AUDIO_Msg:
        u8Result = CAN_CH0_ID_ID_ACK_EXPORT_AUDIO_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ACK_EXPORT_NAV_Msg:
        u8Result = CAN_CH0_ID_ID_ACK_EXPORT_NAV_Msg_Count;
        break;
    case CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg:
        u8Result = CAN_CH0_ID_ID_BSI_CDE_PTR_MESSAGE_Msg_Count;
        break;
    case CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg:
        u8Result = CAN_CH0_ID_ID_CDE_CMB_SIGNALISATION_Msg_Count;
        break;
    case CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg:
        u8Result = CAN_CH0_ID_ID_CDE_COMBINE_TEMOINS_Msg_Count;
        break;
    case CAN_CH0_ID_ID_CDE_PACK_DYN_Msg:
        u8Result = CAN_CH0_ID_ID_CDE_PACK_DYN_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ACK_EVT_DEF_Msg:
        u8Result = CAN_CH0_ID_ID_ACK_EVT_DEF_Msg_Count;
        break;
    case CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg:
        u8Result = CAN_CH0_ID_ID_CDE_PACK_DYN_2_Msg_Count;
        break;
    case CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg:
        u8Result = CAN_CH0_ID_ID_CDE_PRECOND_ET_XVV_Msg_Count;
        break;
    case CAN_CH0_ID_ID_COMMANDES_BSI_Msg:
        u8Result = CAN_CH0_ID_ID_COMMANDES_BSI_Msg_Count;
        break;
    case CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg:
        u8Result = CAN_CH0_ID_ID_DIAG_UDS_ON_CAN_Msg_Count;
        break;
    case CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg:
        u8Result = CAN_CH0_ID_ID_DMD_MAJ_DATE_HEURE_Msg_Count;
        break;
    case CAN_CH0_ID_ID_DONNEES_AAS_Msg:
        u8Result = CAN_CH0_ID_ID_DONNEES_AAS_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg:
        u8Result = CAN_CH0_ID_ID_ETAT_ARTIV_ET_HY_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg:
        u8Result = CAN_CH0_ID_ID_ETAT_PRECOND_ET_XVV_Msg_Count;
        break;
    case CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg:
        u8Result = CAN_CH0_ID_ID_DONNEES_BSI_LENTES_3_Msg_Count;
        break;
    case CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg:
        u8Result = CAN_CH0_ID_ID_DONNEES_BSI_RAPIDES_Msg_Count;
        break;
    case CAN_CH0_ID_ID_TCFG_DMD_Msg:
        u8Result = CAN_CH0_ID_ID_TCFG_DMD_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg:
        u8Result = CAN_CH0_ID_ID_ECRAN_INFO_PROFILS_Msg_Count;
        break;
    case CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg:
        u8Result = CAN_CH0_ID_ID_DONNEES_BSI_LENTES_Msg_Count;
        break;
    case CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg:
        u8Result = CAN_CH0_ID_ID_DONNEES_BSI_LENTES_2_Msg_Count;
        break;
    case CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg:
        u8Result = CAN_CH0_ID_ID_DONNEES_ETAT_ROUES_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ETAT_BSI_TEMP_NIVEAU_Msg:
        u8Result = CAN_CH0_ID_ID_ETAT_BSI_TEMP_NIVEAU_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ETAT_COMBINE_Msg:
        u8Result = CAN_CH0_ID_ID_ETAT_COMBINE_Msg_Count;
        break;
    case CAN_CH0_ID_ID_ETAT_VTH_Msg:
        u8Result = CAN_CH0_ID_ID_ETAT_VTH_Msg_Count;
        break;
    case CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg:
        u8Result = CAN_CH0_ID_ID_EVT_DEFAUT_MATT_Msg_Count;
        break;
    case CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg:
        u8Result = CAN_CH0_ID_ID_EXPORT_AUDIO_CF_Msg_Count;
        break;
    case CAN_CH0_ID_ID_EXPORT_AUDIO_FC_Msg:
        u8Result = CAN_CH0_ID_ID_EXPORT_AUDIO_FC_Msg_Count;
        break;
    case CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg:
        u8Result = CAN_CH0_ID_ID_EXPORT_NAV_CF_Msg_Count;
        break;
    case CAN_CH0_ID_ID_EXPORT_NAV_FC_Msg:
        u8Result = CAN_CH0_ID_ID_EXPORT_NAV_FC_Msg_Count;
        break;
    case CAN_CH0_ID_ID_GESTION_VITESSE_Msg:
        u8Result = CAN_CH0_ID_ID_GESTION_VITESSE_Msg_Count;
        break;
    case CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg:
        u8Result = CAN_CH0_ID_ID_INFOS_GEN_ODB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_INFOS_HYBRIDE_Msg:
        u8Result = CAN_CH0_ID_ID_INFOS_HYBRIDE_Msg_Count;
        break;
    case CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg:
        u8Result = CAN_CH0_ID_ID_INFOS_MAINTENANCE_EV_Msg_Count;
        break;
    case CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg:
        u8Result = CAN_CH0_ID_ID_INFOS_STT_ET_HY_Msg_Count;
        break;
    case CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg:
        u8Result = CAN_CH0_ID_ID_INFOS_TRAJET1_ODB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg:
        u8Result = CAN_CH0_ID_ID_INFOS_TRAJET2_ODB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_INFO_NAV_Msg:
        u8Result = CAN_CH0_ID_ID_INFO_NAV_Msg_Count;
        break;
    case CAN_CH0_ID_ID_INFO_NAV_2_Msg:
        u8Result = CAN_CH0_ID_ID_INFO_NAV_2_Msg_Count;
        break;
    case CAN_CH0_ID_ID_REP_DIAG_MATT_Msg:
        u8Result = CAN_CH0_ID_ID_REP_DIAG_MATT_Msg_Count;
        break;
    case CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg:
        u8Result = CAN_CH0_ID_ID_REQ_DIAG_MATT_Msg_Count;
        break;
    case CAN_CH0_ID_ID_SUPERVISION_MATT_Msg:
        u8Result = CAN_CH0_ID_ID_SUPERVISION_MATT_Msg_Count;
        break;
    case CAN_CH0_ID_ID_VERSION_MATT_Msg:
        u8Result = CAN_CH0_ID_ID_VERSION_MATT_Msg_Count;
        break;
    case CAN_CH0_ID_ID_VMF_DSGN_Msg:
        u8Result = CAN_CH0_ID_ID_VMF_DSGN_Msg_Count;
        break;
    case CAN_CH0_ID_ID_CDE_LED_PUSH_Msg:
        u8Result = CAN_CH0_ID_ID_CDE_LED_PUSH_Msg_Count;
        break;
    case CAN_CH0_ID_ID_CMB_CFG_VOY_Msg:
        u8Result = CAN_CH0_ID_ID_CMB_CFG_VOY_Msg_Count;
        break;
    case CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg:
        u8Result = CAN_CH0_ID_ID_EVT_DEFAUT_CMB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_IS_DAT_ABR_Msg:
        u8Result = CAN_CH0_ID_ID_IS_DAT_ABR_Msg_Count;
        break;
    case CAN_CH0_ID_ID_KM_SAUV_CMB_Msg:
        u8Result = CAN_CH0_ID_ID_KM_SAUV_CMB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_REP_DIAG_CMB_Msg:
        u8Result = CAN_CH0_ID_ID_REP_DIAG_CMB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg:
        u8Result = CAN_CH0_ID_ID_REQ_DIAG_CMB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_SUPERVISION_CMB_Msg:
        u8Result = CAN_CH0_ID_ID_SUPERVISION_CMB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_VERSION_CMB_Msg:
        u8Result = CAN_CH0_ID_ID_VERSION_CMB_Msg_Count;
        break;
    case CAN_CH0_ID_ID_EDR_Msg:
        u8Result = CAN_CH0_ID_ID_EDR_Msg_Count;
        break;
    case CAN_CH0_ID_EGS_Msg:
        u8Result = CAN_CH0_ID_EGS_Msg_Count;
        break;
    case CAN_CH0_ID_ID_CDE_IHM_CLIM_Msg:
        u8Result = CAN_CH0_ID_ID_CDE_IHM_CLIM_Msg_Count;
        break;
    case CAN_CH0_ID_350_Msg:
        u8Result = CAN_CH0_ID_350_Msg_Count;
        break;
    case CAN_CH0_ID_ID294_REMOTE_ACTION_REP_Msg:
        u8Result = CAN_CH0_ID_ID294_REMOTE_ACTION_REP_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

uint8_t  CAN_CH0_SendID_Convert(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_SEND_TOTAL;
      
    switch (MsgID)
    {
        case 0x217:
            u8Result = CAN_CH0_MSGID_217;
            break;
        case 0x317:
            u8Result = CAN_CH0_MSGID_317;
            break;
        case 0x31C:
            u8Result = CAN_CH0_MSGID_31C;
            break;
        case 0x257:
            u8Result = CAN_CH0_MSGID_257;
            break;
        case 0x43C:
            u8Result = CAN_CH0_MSGID_43C;
            break;
        case 0x254:
            u8Result = CAN_CH0_MSGID_254;
            break;
        default :
            u8Result = CAN_CH0_ID_SEND_TOTAL;
            break;
    }

    return u8Result;
    
}

