/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Adc_ADCH_PBTypes.h                                                                                  */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains the type definitions of Post-build Time Parameters                                              */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.1: 24/11/2021 : Added instance 4 to the suppression of duplicate inclusion.
 * 1.3.2: 10/09/2021 : Moved macros of ECM keycode to common header.
 *        08/09/2021 : Changed the names of macros for parity error bit of ECM CFG registers.
 *        06/09/2021 : Update header file macro to call file multiple times.
 *        25/08/2021 : Fixed typo of macro ADC_ADCX_ODCR_INIT_VALUE.
 * 1.3.1: 13/07/2021 : Added macros for Wiring Break Detection Control Register.
 *        07/07/2021 : Added QAC message 9.5.0
 *                     Changed comment format to 120 columns
 *                     Changed violation tag from START/END
 *        24/06/2021 : Removed the macro that not using.
 *        16/06/2021 : Updated by nesting ADC register structures.
 *                     Move scan group definition to "Adc_ADCH_PBTypes.h".
 *        07/04/2021 : Changed to comply with coding rules.
 * 1.2.0: 04/08/2020 : Release
 *                     Add macro ADC_ECM_PARITY_MASK.
 *                     Add QAC 9.3.1 comment.
 *                     Add macro ADC1_ERR_EIC_OFFSET, ADC2_ERR_EIC_OFFSET,
 *                     ADC3_ERR_EIC_OFFSET.
 * 1.1.0: 19/06/2020 : Release
 * 1.0.1: 18/06/2020 : Move macro ADC_INVALID_CHANNELID from Adc_ADCJ_PBTypes.h,
 *                     Adc_ADCH_PBTypes.h to Adc_PBTypes.h and change the value
 *                     to 0xFF
 * 1.0.0: 09/01/2020 : Initial Version
 */
/**********************************************************************************************************************/
#ifdef ADC_INSTANCE_INDEX
  #if (ADC_INSTANCE_INDEX == 0)
    #ifndef ADC_59_INST0_ADCX_PBTYPES_H
      #define ADC_59_INST0_ADCX_PBTYPES_H
      #define ADC_ADCX_PBTYPES_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 1)
    #ifndef ADC_59_INST1_ADCX_PBTYPES_H
      #define ADC_59_INST1_ADCX_PBTYPES_H
      #define ADC_ADCX_PBTYPES_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 2)
    #ifndef ADC_59_INST2_ADCX_PBTYPES_H
      #define ADC_59_INST2_ADCX_PBTYPES_H
      #define ADC_ADCX_PBTYPES_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 3)
    #ifndef ADC_59_INST3_ADCX_PBTYPES_H
      #define ADC_59_INST3_ADCX_PBTYPES_H
      #define ADC_ADCX_PBTYPES_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 4)
    #ifndef ADC_59_INST4_ADCX_PBTYPES_H
      #define ADC_59_INST4_ADCX_PBTYPES_H
      #define ADC_ADCX_PBTYPES_HEADER
    #endif
  #else
    #error "Miss instance index"
  #endif
#else
  #ifndef ADC_ADCX_PBTYPES_H
    #define ADC_ADCX_PBTYPES_H
    #define ADC_ADCX_PBTYPES_HEADER
  #endif
#endif

#ifdef ADC_ADCX_PBTYPES_HEADER
#undef ADC_ADCX_PBTYPES_HEADER                                                                                          /* PRQA S 0841 # JV-01 */


/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:3630)    : The implementation of this struct/union type should be hidden.                               */
/* Rule                : MISRA C:2012 Dir-4.8                                                                         */
/* JV-01 Justification : This is accepted. Redundant of struct or union type has no affect to driver operation        */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3684)    : Array declared with unknown size.                                                            */
/* Rule                : CERTCCM ARR02, MISRA C:2012 Rule-8.11                                                        */
/* JV-01 Justification : Arrays used are verified in the file which are only declarations and size is                 */
/*                       configuration dependent                                                                      */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* Macros for Limit Check Registers */
#define ADC_NUM_OF_LIMIT_REG           2U
#define ADC_ADCX_VCLMSCR2_ALL_MASK     (uint32)0x000000FFUL
#define ADC_ADCX_VCULLMTBR_INIT_VALUE  (uint32)0x7FFE0000UL

/* Macro for Parity Error Register */
#define ADC_ADCX_PER_PECAP             (uint8)0x3FU

/* Macro for Error Clear Register */
#define ADC_ADCX_ECR_CLEAR_ALL         (Adc_ErrClearRegType)0x04U

/* Macros for Wiring Break Detection Control Register */
#define ADC_ADCX_ODCR_INIT_VALUE       (Adc_WireBreakRegType)0x00000000UL
#define ADC_ADCX_ODCR_ODE              (Adc_WireBreakRegType)(1UL << 7U)
#define ADC_ADCX_ODCR_ODDE             (Adc_WireBreakRegType)(1UL << 31U)

/* Macros for ECM Register */
#define ADC_ECM_CFG_ADC_PARITY_ERR     (uint32)(1UL << 24U)

/* AD Convert wait time setting bit for ADCHnSGVCOWR register */
#define ADC_SGVCOWR_VCOW_BIT           (uint16)0x0FFFU

/* Number of wait time registers */
#define ADC_NUM_OF_WAITTIME            (uint8)5U

/* Number of limit check registers */
#define ADC_NUM_OF_LIMIT_TABLE         7UL

/* Macro for EIC error register offset value */
#define ADC1_ERR_EIC_OFFSET            (uint8)0x02U
#define ADC2_ERR_EIC_OFFSET            (uint8)0x01U
#define ADC3_ERR_EIC_OFFSET            (uint8)0x03U

/* Number of scan group */
#define ADC_NUM_SCANGROUP              (uint8)0x05U

/* Number of virtual channel registers */
#define ADC_NUM_OF_VCR                 40U

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
typedef uint32 Adc_WireBreakRegType;
typedef uint8 Adc_ErrClearRegType;

/***********************************************************************************************************************
** Structure for HW Unit Registers, which are used to read or write                                                   **
** the status or configured values for proper working of the ADC driver                                               **
***********************************************************************************************************************/
/* Structure for registers of Scan Group */
typedef struct STag_Adc_SGRegType
{
  volatile uint8  ucADCXnSGSTCRx;                            /* 00H */
  volatile uint8  aaReserved0[3];
  volatile uint8  ucADCXnSGSTPCRx;                           /* 04H */
  volatile uint8  aaReserved1[3];
  volatile uint8  ucADCXnADTSTCRx;                           /* 08H */
  volatile uint8  aaReserved2[3];
  volatile uint8  ucADCXnADTENDCRx;                          /* 0CH */
  volatile uint8  aaReserved3[3];
  volatile uint8  ucADCXnSGCRx;                              /* 10H */
  volatile uint8  aaReserved4[3];
  volatile uint8  ucADCXnSGVCSPx;                            /* 14H */
  volatile uint8  aaReserved5[3];
  volatile uint8  ucADCXnSGVCEPx;                            /* 18H */
  volatile uint8  aaReserved6[3];
  volatile uint8  ucADCXnSGMCYCRx;                           /* 1CH */
  volatile uint8  aaReserved7[3];
  volatile uint16 usADCXnSGVCPRx;                            /* 20H */
  volatile uint8  aaReserved8[2];
  volatile uint8  ucADCXnSGSRx;                              /* 24H */
  volatile uint8  aaReserved9[3];
  volatile uint32 ulADCXnADTIPRx;                            /* 28H */
  volatile uint32 ulADCXnADTPRRx;                            /* 2CH */
  volatile uint8  aaReserved10[4];
  volatile uint16 usADCXnSGVCOWRx;                           /* 34H */
  volatile uint8  aaReserved11[74];
} Adc_SGRegType;                                             /* size 80H */

/* Structure for ADCH registers */
typedef struct STag_Adc_ConfigRegisters                                                                                 /* PRQA S 3630 # JV-01 */
{
  volatile uint32 aaADCXnVCR[ADC_NUM_OF_VCR];                /* 000H */
  volatile uint8  aaReserved0[96];
  volatile uint16 aaADCXnDR[ADC_NUM_OF_VCR];                 /* 100H */
  volatile uint8  aaReserved1[176];
  volatile uint32 aaADCXnDIR[ADC_NUM_OF_VCR];                /* 200H */
  volatile uint8  aaReserved2[96];
  volatile uint8  ucADCXnADSYNSTCR;                          /* 300H */
  volatile uint8  aaReserved3[3];
  volatile uint8  ucADCXnADTSYNSTCR;                         /* 304H */
  volatile uint8  aaReserved4[7];
  volatile uint8  ucADCXnVMONVDCR1;                          /* 30CH */
  volatile uint8  aaReserved5[3];
  volatile uint8  ucADCXnVMONVDCR2;                          /* 310H */
  volatile uint8  aaReserved6[111];
  volatile uint8  ucADCXnADHALTR;                            /* 380H */
  volatile uint8  aaReserved7[3];
  volatile uint8  ucADCXnADCR1;                              /* 384H */
  volatile uint8  aaReserved8[3];
  volatile uint8  ucADCXnMPXCURCR;                           /* 388H */
  volatile uint8  aaReserved9[1];
  volatile uint8  ucADCXnMPXINTER;                           /* 38AH */
  volatile uint8  aaReserved10[1];
  volatile uint32 ulADCXnMPXCURR;                            /* 38CH */
  volatile uint8  ucADCXnMPXOWR;                             /* 390H */
  volatile uint8  aaReserved11[3];
  volatile uint8  ucADCXnMPXCMDR;                            /* 394H */
  volatile uint8  aaReserved12[3];
  volatile uint8  ucADCXnADCR2;                              /* 398H */
  volatile uint8  aaReserved13[3];
  volatile uint16 usADCXnDFASENTSGER;                        /* 39CH */
  volatile uint8  aaReserved14[2];
  volatile uint8  ucADCXnADENDP;                             /* 3A0H */
  volatile uint8  aaReserved15[31];
  volatile uint8  ucADCXnSFTCR;                              /* 3C0H */
  volatile uint8  aaReserved16[3];
  volatile uint8  ucADCXnTDCR;                               /* 3C4H */
  volatile uint8  aaReserved17[3];
  volatile Adc_WireBreakRegType ddADCXnODCR;                 /* 3C8H */
  volatile uint8  aaReserved18[12];
  volatile Adc_ErrClearRegType ddADCXnECR;                   /* 3D8H */
  volatile uint8  aaReserved19[7];
  volatile uint8  ucADCXnOWER;                               /* 3E0H */
  volatile uint8  aaReserved20[3];
  volatile uint8  ucADCXnPER;                                /* 3E4H */
  volatile uint8  aaReserved21[155];
  volatile Adc_SGRegType aaADCXnSG[ADC_NUM_SCANGROUP];       /* 480H */
  volatile uint32 aaADCXnVCULLMTBRy[ADC_NUM_OF_LIMIT_TABLE]; /* 700H */
  volatile uint32 aaReserved34[5];
  volatile uint32 aaADCXnVCLMINTER[ADC_NUM_OF_LIMIT_REG];    /* 730H */
  volatile uint32 aaADCXnVCLMSR[ADC_NUM_OF_LIMIT_REG];       /* 738H */
  volatile uint32 aaADCXnVCLMSCR[ADC_NUM_OF_LIMIT_REG];      /* 740H */
} Adc_ConfigRegisters;                                       /* size 748H */

/***********************************************************************************************************************
** Structure for wait time configuration                                                                              **
***********************************************************************************************************************/
typedef struct STag_Adc_WaitTimeConfigType
{
  /* Store value of ADCHnSGVCOWRx */
  uint16 usSGVCOWRx[ADC_NUM_OF_WAITTIME];
} Adc_WaitTimeConfigType;

/***********************************************************************************************************************
**                                Extern declarations for Global Arrays Of Structures                                 **
***********************************************************************************************************************/
#define ADC_START_SEC_CONFIG_DATA_32
#include "Adc_Mapping.h"

#if (ADC_HW_TRIGGER_API == STD_ON)
/* Declaration for Trigger Out Configuration */
extern CONST(uint32, ADC_CONFIG_DATA) Adc_GaaTriggOutConfigType[];                                                      /* PRQA S 3684 # JV-01 */

/* Declaration for Trigger Out Configuration registers */
extern CONST(uint32, ADC_CONFIG_DATA) Adc_GaaTriggOutConfigRegister[];                                                  /* PRQA S 3684 # JV-01 */
#endif /* (ADC_HW_TRIGGER_API == STD_ON) */

#define ADC_STOP_SEC_CONFIG_DATA_32
#include "Adc_Mapping.h"

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#endif /* ADC_ADCX_PBTYPES_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
