/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_ETNB_Irq.h                                                                                      */
/* SW-VERSION   = 1.6.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision of prototypes for Interrupt service routine for ethernet driver.                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.5.2: 24/01/2022    : Add macro definition related to the fixing of the ETH_AVBnMNGISR and ETH_AVB1STAISR function
 * 1.4.2: 24/08/2021    : Modify the format to 120 characters
 * 1.4.1: 07/05/2021    : Remove vendor ID from the file name, API names
 *                        and parameters according to BSW00347 requirement
 *        09/06/2021    : Remove QA-C Warning 3432 according to QA-C 9.5.0
 *        06/07/2021    : Updated QA-C 9.5.0 comments.
 * 1.2.0: 13/07/2020    : Release
 *        29/07/2020    : Add QAC 9.3.1 comment.
 * 1.1.0: 19/06/2020    : Release
 * 1.0.1: 04/06/2020    : Removed unnecessary code.
 *                        Changed include file structure.
 * 1.0.0: 25/03/2020    : Initial Version
 */
/**********************************************************************************************************************/
#ifndef ETH_ETNB_IRQ_H
#define ETH_ETNB_IRQ_H
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
#include "Eth_Types.h"
/* Included for version information macros */
#include "Os.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ETH_ETNB_IRQ_AR_RELEASE_MAJOR_VERSION    ETH_AR_RELEASE_MAJOR_VERSION
#define ETH_ETNB_IRQ_AR_RELEASE_MINOR_VERSION    ETH_AR_RELEASE_MINOR_VERSION
#define ETH_ETNB_IRQ_AR_RELEASE_REVISION_VERSION ETH_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ETH_ETNB_IRQ_SW_MAJOR_VERSION            ETH_SW_MAJOR_VERSION
#define ETH_ETNB_IRQ_SW_MINOR_VERSION            ETH_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

#define ETH_SGOPMS_GSPEED_MASK                   0x00000008UL
#define ETH_SGOPMS_DATA_COM                      0x00020000UL
#define ETH_SGOPMS_XMIT_MASK                     0x00030000UL

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#define ETH_START_SEC_CODE_FAST
#include "Eth_MemMap.h"
#if (ETH_AVB0_DATA_ISR == STD_ON)
#if defined(Os_ETH_AVB0DATAISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_AVB0DATAISR(void);
#endif
#endif

#if (ETH_AVB0_ERR_ISR == STD_ON)
#if defined(Os_ETH_AVB0ERRISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_AVB0ERRISR(void);
#endif
#endif

#if (ETH_AVB0_MNG_ISR == STD_ON)
#if defined(Os_ETH_AVB0MNGISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_AVB0MNGISR(void);
#endif
#endif

#if (ETH_AVB1_DATA_ISR == STD_ON)
#if defined(Os_ETH_AVB1DATAISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_AVB1DATAISR(void);
#endif
#endif

#if (ETH_AVB1_ERR_ISR == STD_ON)
#if defined(Os_ETH_AVB1ERRISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_AVB1ERRISR(void);
#endif
#endif

#if (ETH_AVB1_MNG_ISR == STD_ON)
#if defined(Os_ETH_AVB1MNGISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_AVB1MNGISR(void);
#endif
#endif

#if (ETH_AVB1_STA_ISR == STD_ON)
#if defined(Os_ETH_AVB1STAISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_AVB1STAISR(void);
#endif
#endif

#define ETH_STOP_SEC_CODE_FAST
#include "Eth_MemMap.h"

#endif /* ETH_ETNB_IRQ_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
