/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_ETNB_Ram.h                                                                                      */
/* SW-VERSION   = 1.6.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains Ethernet driver global variables and the                                                        */
/* Ram Allocation functions                                                                                           */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.5.2: 28/01/2022    : Change the name of Eth_GaaTempTimeStamp to Eth_GaaRxFrame.
 *                        Generate some global variables with the Generation tool to support multiple ETH controls.
 *                        Removed volatile attributes that have no effect.
 *        27/01/2022    : Change the type of Eth_GaaTempTimeStamp from global pointer to global variable
 *        24/01/2022    : Changed the parameter of Eth_ReleaseTxBuffer function.
 *                        Changed the type of Eth_GaaTempTimeStamp variable.
 * 1.5.0: 07/10/2021    : For support U2Bx, added the extern definition of the following global variables.
 *                        Eth_GaaDemEventAccess, Eth_GaaDemEventRxFramesLost, Eth_GaaDemEventCRC,
 *                        Eth_GaaDemEventUnderSizeFrame, Eth_GaaDemEventOverSizeFrame, Eth_GaaDemEventAlignment,
 *                        Eth_GaaDemEventSinglecollision, Eth_GaaDemEventMultiplecollision,
 *                        Eth_GaaDemEventLatecollision, Eth_GaaDemEventIntInconsistent,
 *                        Eth_GaaDemEventRegisterCorruption and Eth_GaaDemEventDmaError.
 * 1.4.2: 24/08/2021    : Modify the format to 120 characters
 * 1.4.1: 07/05/2021    : Remove vendor ID from the file name, API names
 *                        and parameters according to BSW00347 requirement
 *        09/06/2021    : Remove QA-C Warning 3432 according to QA-C 9.5.0
 *        06/07/2021    : Updated QA-C 9.5.0 comments.
 * 1.2.0: 13/07/2020    : Release
 *        29/07/2020    : Add QAC 9.3.1 comment.
 * 1.1.0: 19/06/2020    : Release
 * 1.0.1: 04/06/2020    : Add Eth_59_GpRamManager global variable.
 *                        Change memory class of Eth_59_GaaMemPoolBufferTable
 *                        and Eth_59_GaaTempTimeStamp.
 *                        Removed unnecessary code.
 *                        Added Eth_59_GaaTxBufferIndex declaration.
 *                        Removed Eth_59_GaaTxPendingBuffer global variable.
 *                        Update for improvement by the QA-C.
 *                        Changed include file structure.
 *                        Changed parameter of Eth_59_ReleaseTxBuffer.
 *                        Added Eth_59_GaaDemEventTimeroffsetFailed declaration.
 *                        Changed parameters of Eth_59_PreprocessFrame
 *                        to fix violation of EthSwt AUTOSAR specification.
 * 1.0.0: 25/03/2020    : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/*                       REFERENCE - ISO:C90-6.3.1 Primary Expressions                                                */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is           */
/*                       accepted.                                                                                    */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3472)    : All toplevel uses of this function-like macro look like they could be replaced by            */
/*                       equivalent function calls.                                                                   */
/* Rule                : MISRA C:2012 Dir-4.9                                                                         */
/* JV-01 Justification : To prevent overhead and speed up the processing, there is no need to use function call for   */
/*                       such a small operation.                                                                      */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
#ifndef ETH_ETNB_RAM_H
#define ETH_ETNB_RAM_H
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for utility definitions */
#include "Eth_Common_LLDriver.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ETH_ETNB_RAM_AR_RELEASE_MAJOR_VERSION    ETH_AR_RELEASE_MAJOR_VERSION
#define ETH_ETNB_RAM_AR_RELEASE_MINOR_VERSION    ETH_AR_RELEASE_MINOR_VERSION
#define ETH_ETNB_RAM_AR_RELEASE_REVISION_VERSION ETH_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ETH_ETNB_RAM_SW_MAJOR_VERSION            ETH_SW_MAJOR_VERSION
#define ETH_ETNB_RAM_SW_MINOR_VERSION            ETH_SW_MINOR_VERSION
/***********************************************************************************************************************
**                                              MISRA C Rule Violations                                               **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    QAC Warning                                                     **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
#define ETH_START_SEC_VAR_NO_INIT_BOOLEAN
#include "Eth_MemMap.h"

#define ETH_STOP_SEC_VAR_NO_INIT_BOOLEAN
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_8
#include "Eth_MemMap.h"

#define ETH_STOP_SEC_VAR_NO_INIT_8
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_16
#include "Eth_MemMap.h"

#define ETH_STOP_SEC_VAR_NO_INIT_16
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_32
#include "Eth_MemMap.h"

extern VAR(Eth_BufIdxType, ETH_VAR_NO_INIT) Eth_GaaRxBufferIndex[ETH_TOTAL_CTRL_CONFIG];

extern VAR(Eth_RxSingleFrameType, ETH_VAR_NO_INIT) Eth_GaaRxFrame[ETH_TOTAL_CTRL_CONFIG];

#define ETH_STOP_SEC_VAR_NO_INIT_32
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_PTR
#include "Eth_MemMap.h"

/* Global variable to store pointer to Configuration */
extern P2CONST(Eth_CtrlConfigType, ETH_CONST, ETH_CONFIG_CONST) volatile Eth_GpCtrlConfigPtr;
extern P2CONST(Eth_EthConfigType, ETH_CONST, ETH_CONFIG_CONST) volatile Eth_GpEthConfigPtr;

extern P2VAR(Eth_MemManagerType, ETH_VAR_FAST_NO_INIT, ETH_VAR_FAST_NO_INIT)                                            /* PRQA S 3432 # JV-01 */
    Eth_GpRamManager[ETH_TOTAL_CTRL_CONFIG];

#define ETH_STOP_SEC_VAR_NO_INIT_PTR
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Eth_MemMap.h"

extern VAR(Eth_MacAddressType, ETH_VAR_NO_INIT)
    Eth_GaaAddressFilters[ETH_TOTAL_CTRL_CONFIG][ETH_MAX_FILTERS];

extern VAR(Eth_ControllerStatusType, ETH_VAR_NO_INIT) Eth_GaaCtrlStat[ETH_TOTAL_CTRL_CONFIG];

extern VAR(Eth_ListType, ETH_VAR_NO_INIT) Eth_GaaBufferLock[ETH_TOTAL_CTRL_CONFIG][ETH_TXQ_NUM];

extern VAR(Eth_RxChConfigType, ETH_VAR_NO_INIT) Eth_GaaRxConfig[ETH_RXQ_NUM];

extern VAR(Eth_AvbConfigType, ETH_VAR_NO_INIT) Eth_GaaAvbConfig[ETH_TOTAL_CTRL_CONFIG];

extern VAR(Eth_QConfigType, ETH_VAR_NO_INIT) Eth_GaaQConfig[ETH_RXQ_NUM];

extern VAR(Eth_TxBufferType, ETH_VAR_NO_INIT) Eth_GaaTxBufferIndex[ETH_TOTAL_CTRL_CONFIG][ETH_TX_DESC_MAX];

#define ETH_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_INIT_BOOLEAN
#include "Eth_MemMap.h"

#define ETH_STOP_SEC_VAR_INIT_BOOLEAN
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_INIT_8
#include "Eth_MemMap.h"

#define ETH_STOP_SEC_VAR_INIT_8
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_INIT_16
#include "Eth_MemMap.h"

#define ETH_STOP_SEC_VAR_INIT_16
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_INIT_32
#include "Eth_MemMap.h"

#define ETH_STOP_SEC_VAR_INIT_32
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_INIT_PTR
#include "Eth_MemMap.h"

#define ETH_STOP_SEC_VAR_INIT_PTR
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_INIT_UNSPECIFIED
#include "Eth_MemMap.h"

/* Global variable to store  Controller State */
extern VAR(Eth_StateType, ETH_VAR_INIT) Eth_GenDriverState;

#define ETH_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Eth_MemMap.h"

/***********************************************************************************************************************
**                                                   Macro Defines                                                    **
***********************************************************************************************************************/
#define ETH_DWORD_SIZE        4UL
#define ETH_ALIGN_TO_32BIT(n) ((((n) + ETH_DWORD_SIZE) - 1UL) & 0xFFFFFFFCUL)                                           /* PRQA S 3472 # JV-01 */

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define ETH_START_SEC_PRIVATE_CODE
#include "Eth_MemMap.h"
extern FUNC(void, ETH_PRIVATE_CODE) Eth_InitializeBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx);
extern FUNC(void, ETH_PRIVATE_CODE) Eth_PreprocessBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx);
extern FUNC(BufReq_ReturnType, ETH_PRIVATE_CODE)
    Eth_GetTxBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint8, AUTOMATIC) LucPriority,
                    CONSTP2VAR(Eth_BufIdxType, AUTOMATIC, ETH_APPL_DATA) LpBufIdxPtr,                                   /* PRQA S 3432 # JV-01 */
                    CONSTP2VAR(uint8 *, AUTOMATIC, ETH_APPL_DATA) LpBufPtr,                                             /* PRQA S 3432 # JV-01 */
                    CONSTP2VAR(uint16, AUTOMATIC, ETH_APPL_DATA) LenBytePtr);                                           /* PRQA S 3432 # JV-01 */
extern FUNC(void, ETH_PRIVATE_CODE)
    Eth_ReleaseTxBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx,
                        CONST(uint32, AUTOMATIC) LulBufIdx);
extern FUNC(Std_ReturnType, ETH_PRIVATE_CODE)
    Eth_CheckProvideBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulBufIdx);
extern FUNC(void, ETH_PRIVATE_CODE)
    Eth_PreprocessFrame(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulBufIdx,
                        CONST(uint32, AUTOMATIC) LulFrameType,
                        CONSTP2CONST(uint8, AUTOMATIC, ETH_APPL_DATA) LpPhysAddrPtr,
                        CONSTP2VAR(uint16, AUTOMATIC, ETH_APPL_DATA) LpPayloadLen);                                     /* PRQA S 3432 # JV-01 */
extern FUNC(void, ETH_PRIVATE_CODE)
    Eth_Ram_Init(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulBaseAddr,
                 CONST(uint32, AUTOMATIC) LulRamSize);

extern FUNC(uint32, ETH_PRIVATE_CODE)
    Eth_Ram_Alloc(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulRamSize);

extern FUNC(void, ETH_PRIVATE_CODE)
    Eth_Ram_Free(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulMemAddr);

extern FUNC(uint32, ETH_PRIVATE_CODE) Eth_Ram_GetNextFreeAddr(CONST(uint32, AUTOMATIC) LulCtrlIdx);

extern FUNC(void, ETH_PRIVATE_CODE) Eth_Ram_SetCircularAddr(CONST(uint32, AUTOMATIC) LulCtrlIdx);

extern FUNC(boolean, ETH_PRIVATE_CODE)
    Eth_Ram_CheckValidAddr(Eth_ListType *LpList, uint32 *LpStartAddr, uint32 LulRamSize);

extern FUNC(Eth_BufHandlerType *, ETH_PRIVATE_CODE)
    Eth_FindTxBufferHandler(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulBufIdx);

#define ETH_STOP_SEC_PRIVATE_CODE
#include "Eth_MemMap.h"
#endif /* ETH_ETNB_RAM_H  */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
