/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Fls_Ram.c                                                                                           */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision of Global variable definitions for Flash Wrapper Component.                                              */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.3:  12/05/2022  : Update SUPPORTED -> FLS_SUPPORTED
 * 1.3.1:  02/07/2021  : Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.3.0:  21/01/2021  : Enclose Fls_GstVar, Fls_GstBackUpVar and Fls_GenFcuMode to
 *                       START/STOP_SEC_VAR_NO_INIT_UNSPECIFIED section.
 * 1.2.0:  21/06/2020  : Release
 *         28/07/2020  : Add QAC 9.3.1 Message
 * 1.1.0:  19/06/2020  : Release
 * 1.0.1:  23/04/2020  : Update Format dd/mm/yyyy and revision format
 * 1.0.0:  20/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for macro definitions and API prototypes */
#include "Fls.h"                                                                                                        /* PRQA S 0857 # JV-01 */
/* Included for RAM variable declarations */
#include "Fls_Ram.h"                                                                                                    /* PRQA S 0857 # JV-01 */

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define FLS_RAM_C_AR_RELEASE_MAJOR_VERSION    FLS_AR_RELEASE_MAJOR_VERSION_VALUE
#define FLS_RAM_C_AR_RELEASE_MINOR_VERSION    FLS_AR_RELEASE_MINOR_VERSION_VALUE
#define FLS_RAM_C_AR_RELEASE_REVISION_VERSION FLS_AR_RELEASE_REVISION_VERSION_VALUE
/* File version information */
#define FLS_RAM_C_SW_MAJOR_VERSION            FLS_SW_MAJOR_VERSION_VALUE
#define FLS_RAM_C_SW_MINOR_VERSION            FLS_SW_MINOR_VERSION_VALUE

/***********************************************************************************************************************
**                                                   Version Check                                                    **
***********************************************************************************************************************/
#if (FLS_RAM_AR_RELEASE_MAJOR_VERSION != FLS_RAM_C_AR_RELEASE_MAJOR_VERSION)
    #error "Fls_Ram.c : Mismatch in Release Major Version"
#endif

#if (FLS_RAM_AR_RELEASE_MINOR_VERSION != FLS_RAM_C_AR_RELEASE_MINOR_VERSION)
    #error "Fls_Ram.c : Mismatch in Release Minor Version"
#endif

#if (FLS_RAM_AR_RELEASE_REVISION_VERSION != FLS_RAM_C_AR_RELEASE_REVISION_VERSION)
    #error "Fls_Ram.c : Mismatch in Release Revision Version"
#endif

#if (FLS_RAM_SW_MAJOR_VERSION != FLS_RAM_C_SW_MAJOR_VERSION)
    #error "Fls_Ram.c : Mismatch in Software Major Version"
#endif

#if (FLS_RAM_SW_MINOR_VERSION != FLS_RAM_C_SW_MINOR_VERSION)
    #error "Fls_Ram.c : Mismatch in Software Minor Version"
#endif

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0857)    : Number of macro definitions exceeds 1024 - program does not conform strictly to ISO:C90.     */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : The number of macro depend on module code size. There is no issue when number of macro is    */
/*                       over 1024                                                                                    */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object '%1s' is referenced in only one translation unit - but not the one in which it    */
/*                       is defined.                                                                                  */
/* Rule                : CERTCCM DCL15, DCL19, MISRA C:2012 Rule-8.7                                                  */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in separated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    Global Data                                                     **
***********************************************************************************************************************/
#define FLS_START_SEC_VAR_NO_INIT_PTR
#include "Fls_MemMap.h"

/* Global variable to store pointer to Post build Configuration */
P2CONST(Fls_ConfigType, FLS_VAR_NO_INIT, FLS_CONFIG_DATA) Fls_GpConfigPtr;

#define FLS_STOP_SEC_VAR_NO_INIT_PTR
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define FLS_START_SEC_VAR_INIT_UNSPECIFIED
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/* Variable to store the job result */
VAR(volatile MemIf_JobResultType, FLS_VAR_INIT) Fls_GenJobResult = MEMIF_JOB_OK;

/* Variable to store the driver state */
VAR(volatile MemIf_StatusType, FLS_VAR_INIT) Fls_GenState = MEMIF_UNINIT;

/* Variable to Hold the Current Mode during Read operation*/
VAR(volatile MemIf_ModeType, FLS_VAR_INIT) Fls_GenCurrentMode = MEMIF_MODE_SLOW;

#define FLS_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define FLS_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/* Structure variable that contains FLS Global variables required for
 * FLS operation.
 */
VAR(volatile Fls_GstVarProperties, FLS_VAR_NO_INIT) Fls_GstVar;

#if ((FLS_SUSPEND_API == STD_ON) || (FLS_RESUME_API == STD_ON))
/* Structure variable to Back Up Global Variables in case of Job Suspend */
VAR(volatile Fls_GstVarProperties, FLS_VAR_NO_INIT) Fls_GstBackUpVar;
#endif

/* Variable to Hold Current Flash operating mode: P/E or Read */
VAR(volatile T_en_FACIMode, FLS_VAR_NO_INIT) Fls_GenFcuMode;                                                            /* PRQA S 1531 # JV-01 */

#define FLS_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define FLS_START_SEC_VAR_INIT_BOOLEAN
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#if (FLS_TIMEOUT_MONITORING_ENABLE == STD_ON)
/* Variable to monitor the occurrence of Timeout  */
VAR(volatile boolean, FLS_VAR_INIT) Fls_GblTimeOutMonitor = FLS_FALSE;
#endif

#if (FLS_INTERRUPT_MODE == STD_ON)

/* Variable to store the Interrupt request flag status */
VAR(volatile boolean, FLS_VAR_INIT) Fls_GblIntrRqstFlag = FLS_FALSE;

#endif /* #if (FLS_INTERRUPT_MODE == STD_ON) */

#define FLS_STOP_SEC_VAR_INIT_BOOLEAN
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define FLS_START_SEC_VAR_NO_INIT_BOOLEAN
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#if (FLS_FHVE_REGS == FLS_SUPPORTED)
/* Variable to store the flash protection state */
VAR(volatile boolean, FLS_VAR_NO_INIT) Fls_GblFlashEnable;
#endif /* end of #if (FLS_FHVE_REGS == FLS_SUPPORTED) */

#if ((FLS_SUSPEND_API == STD_ON) || (FLS_RESUME_API == STD_ON))
/* Variable to store the Job Suspended state */
VAR(volatile boolean, FLS_VAR_NO_INIT) Fls_GblJobSuspended;
#endif
#if (FLS_SUSPEND_API == STD_ON)
/* Variable to store the Job Suspended request state */
VAR(volatile boolean, FLS_VAR_NO_INIT) Fls_GblJobSuspendRequest;
#endif

#if (FLS_RESUME_API == STD_ON)
/* Variable to store the Job Resume request state */
VAR(volatile boolean, FLS_VAR_NO_INIT) Fls_GblJobResumeRequest;
#endif

#define FLS_STOP_SEC_VAR_NO_INIT_BOOLEAN
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define FLS_START_SEC_VAR_NO_INIT_32
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#if (FLS_TIMEOUT_MONITORING_ENABLE == STD_ON)
/* Variable to store the Time out value to be used for generating Timeout  */
VAR(volatile uint32, FLS_VAR_NO_INIT) Fls_GulTimeOutCounter;
#endif

#define FLS_STOP_SEC_VAR_NO_INIT_32
#include "Fls_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/***********************************************************************************************************************
**                                                Function Definitions                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
