/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_TAUJ_PBTypes.h                                                                                  */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020, 2021 Renesas Electronics Corporation. All rights reserved.                                               */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains macros and structure data types for post build parameters of ICU Driver                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        U2A                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.3.2:  30/08/2021  : Update header file macro.
 * 1.3.1:  02/07/2021  : Format source code to 120 characters
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)
        #ifndef ICU_59_INST0_TAUJ_PBTYPES_H
            #define ICU_59_INST0_TAUJ_PBTYPES_H
            #define ICU_TAUJ_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_TAUJ_PBTYPES_H
            #define ICU_59_INST1_TAUJ_PBTYPES_H
            #define ICU_TAUJ_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_TAUJ_PBTYPES_H
            #define ICU_59_INST2_TAUJ_PBTYPES_H
            #define ICU_TAUJ_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_TAUJ_PBTYPES_H
            #define ICU_59_INST3_TAUJ_PBTYPES_H
            #define ICU_TAUJ_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_TAUJ_PBTYPES_H
            #define ICU_59_INST4_TAUJ_PBTYPES_H
            #define ICU_TAUJ_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_TAUJ_PBTYPES_H
            #define ICU_59_INST5_TAUJ_PBTYPES_H
            #define ICU_TAUJ_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_TAUJ_PBTYPES_H
            #define ICU_59_INST6_TAUJ_PBTYPES_H
            #define ICU_TAUJ_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_TAUJ_PBTYPES_H
            #define ICU_59_INST7_TAUJ_PBTYPES_H
            #define ICU_TAUJ_PBTYPES_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_TAUJ_PBTYPES_H
        #define ICU_TAUJ_PBTYPES_H
        #define ICU_TAUJ_PBTYPES_HEADER
    #endif
#endif

#ifdef ICU_TAUJ_PBTYPES_HEADER
#undef ICU_TAUJ_PBTYPES_HEADER                                                                                          /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/* To avoid QAC error */
#include "Icu_PBTypes.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ICU_TAUJ_PBTYPES_AR_RELEASE_MAJOR_VERSION    ICU_AR_RELEASE_MAJOR_VERSION
#define ICU_TAUJ_PBTYPES_AR_RELEASE_MINOR_VERSION    ICU_AR_RELEASE_MINOR_VERSION
#define ICU_TAUJ_PBTYPES_AR_RELEASE_REVISION_VERSION ICU_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ICU_TAUJ_PBTYPES_SW_MAJOR_VERSION            ICU_SW_MAJOR_VERSION
#define ICU_TAUJ_PBTYPES_SW_MINOR_VERSION            ICU_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
#define ICU_TAUJ_TIMER_RESET_VAL                     (uint8)0x0F
#define ICU_TAUJ_TPS_RESET_VAL                       (uint16)0xFFFF
#define ICU_TAUJ_BRS_RESET_VAL                       (uint8)0x00
#define ICU_TAUJ_CSC_RESET_VAL                       (uint8)0x01
#define ICU_TAUJ_CMUR_RESET_VAL                      (uint8)0x00
#define ICU_TAUJ_CDR_RESET_VAL                       (uint32)0x00000000UL
#define ICU_TAUJ_CMOR_RESET_VAL                      (uint16)0x0000

/***********************************************************************************************************************
**                                      SchM Critical Section Protection Macros                                       **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                     Structure for TAU Unit configuration type                                      **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                           Data structure for Timer Array Units J user control registers                            **
***********************************************************************************************************************/
#if (ICU_TAUJ_UNIT_USED == STD_ON)
typedef struct STag_Icu_TAUJUnitUserRegs
{
  uint8 volatile ucTAUJnTE;
  uint8 volatile ucReserved1;
  uint16 volatile usReserved2;
  uint8 volatile ucTAUJnTS;
  uint8 volatile ucReserved3;
  uint16 volatile usReserved4;
  uint8 volatile ucTAUJnTT;
  uint8 volatile aaReserved5[ICU_THREE];
  uint8 volatile ucTAUJnTO;
  uint8 volatile aaReserved6[ICU_THREE];
  uint8 volatile ucTAUJnTOE;
  uint8 volatile aaReserved7[ICU_THREE];
  uint8 volatile ucTAUJnTOL;
  uint8 volatile aaReserved8[ICU_THREE];
  uint8 volatile ucTAUJnRDT;
  uint8 volatile aaReserved9[ICU_THREE];
  uint8 volatile ucTAUJnRSF;
} Icu_TAUJUnitUserRegs;
#endif /*   #if (ICU_TAUJ_UNIT_USED == STD_ON) */

/***********************************************************************************************************************
**                            Data structure for Timer Array Units J os control registers                             **
***********************************************************************************************************************/
#if (ICU_TAUJ_UNIT_USED == STD_ON)
typedef struct STag_Icu_TAUJUnitOsRegs
{
  uint16 volatile usTAUJnTPS;
  uint16 volatile usReserved1;
  uint8 volatile ucTAUJnBRS;
  uint8 volatile aaReserved2[ICU_THREE];
  uint8 volatile ucTAUJnTOM;
  uint8 volatile aaReserved3[ICU_THREE];
  uint8 volatile ucTAUJnTOC;
  uint8 volatile aaReserved4[ICU_THREE];
  uint8 volatile ucTAUJnRDE;
  uint8 volatile aaReserved5[ICU_THREE];
  uint8 volatile ucTAUJnRDM;
} Icu_TAUJUnitOsRegs;
#endif /*   #if (ICU_TAUJ_UNIT_USED == STD_ON) */

/***********************************************************************************************************************
**                       Data structure for Timer Array Units J channel user control registers                        **
***********************************************************************************************************************/
#if (ICU_TAUJ_UNIT_USED == STD_ON)
typedef struct STag_Icu_TAUJChannelUserRegs
{
  uint32 volatile ulTAUJnCDRm;
  uint32 volatile aaReserved1[ICU_THREE];
  uint32 volatile ulTAUJnCNTm;
  uint32 volatile aaReserved2[ICU_THREE];
  uint8 volatile ucTAUJnCMURm;
  uint8 volatile ucReserved3;
  uint16 volatile aaReserved4[ICU_SEVEN];
  uint8 volatile ucTAUJnCSRm;
  uint8 volatile ucReserved5;
  uint16 volatile aaReserved6[ICU_SEVEN];
  uint8 volatile ucTAUJnCSCm;
} Icu_TAUJChannelUserRegs;
#endif /* End of (ICU_TAUJ_UNIT_USED == STD_ON) */

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#endif /* ICU_TAUJ_PBTYPES_HEADER  */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
