/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Lin_RLIN3_LLDriver.h                                                                                */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2019-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Header file for Lin_RLIN3_LLDriver.c.                                                                              */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 *
 * 1.4.3:  14/04/2022  : Update SW-VERSION to 1.4.3
 * 1.3.2:  04/03/2022  : Update SW-VERSION
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0.
 *                       Format source code to 120 characters.
 *                       Improve Violation tag (remove START/END).
 * 1.2.0:  26/08/2020  : Release.
 * 1.1.0:  19/06/2020  : Release.
 * 1.0.1:  16/04/2020  : Modified #include heading files.
 *         19/03/2019  : Fix QAC
 *                         1. Update "MISRA C Rule Violations" and "QAC warning"
 *                            message from MISRA-C:2004 to MISRA-C:2012.
 *                         2. Move static function prototypes from header file
 *                            to source file.
 * 1.0.0:  12/03/2019  : Initial Version.
 *
 */
/**********************************************************************************************************************/

#ifndef LIN_RLIN3_LLDRIVER_H
#define LIN_RLIN3_LLDRIVER_H

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (7:0791)    : Macro identifier does not differ from other macro identifier(s) (e.g. '%s') within the       */
/*                       specified number of significant characters.                                                  */
/* Rule                : CERTCCM DCL23, MISRA C:2012 Rule-5.4                                                         */
/* JV-01 Justification : This macro identifier is following AUTOSAR standard rule (Symbolic Name or Published         */
/*                       Macro's name), so this is accepted.                                                          */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define LIN_RLIN3_LLDRIVER_AR_RELEASE_MAJOR_VERSION    LIN_AR_RELEASE_MAJOR_VERSION
#define LIN_RLIN3_LLDRIVER_AR_RELEASE_MINOR_VERSION    LIN_AR_RELEASE_MINOR_VERSION                                     /* PRQA S 0791 # JV-01 */
#define LIN_RLIN3_LLDRIVER_AR_RELEASE_REVISION_VERSION LIN_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define LIN_RLIN3_LLDRIVER_SW_MAJOR_VERSION            LIN_SW_MAJOR_VERSION
#define LIN_RLIN3_LLDRIVER_SW_MINOR_VERSION            LIN_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                             Global Function Prototypes                                             **
***********************************************************************************************************************/

#define LIN_START_SEC_CODE_FAST
#include "Lin_MemMap.h"

/* Interrupt handler function of transmition interrupt for channels */
extern FUNC(void, LIN_CODE_FAST) Lin_TxIsr(const uint8 LucChannel);

/* Interrupt handler function of reception interrupt for channels */
extern FUNC(void, LIN_CODE_FAST) Lin_RxIsr(const uint8 LucChannel);

/* Interrupt handler function of error interrupt for channels */
extern FUNC(void, LIN_CODE_FAST) Lin_ErrIsr(const uint8 LucChannel);

extern FUNC(Std_ReturnType, LIN_CODE_FAST)
    Lin_HwSetMasterMode(const uint8 LucChannel, const Lin_ModeType LenModeType, const uint8 LucApiId);

extern FUNC(void, LIN_CODE_FAST)
    Lin_HwScheduleInterrupt(const uint8 LucChannel, const Lin_InterruptScheduleType LenInterruptScheduleType);

extern FUNC(Std_ReturnType, LIN_CODE_FAST)
    Lin_HwHandleWakeupRequest(const uint8 LucChannel, const Lin_WakeupType LenWakeupType, const uint8 LucApiId);

#define LIN_STOP_SEC_CODE_FAST
#include "Lin_MemMap.h"

#define LIN_START_SEC_PRIVATE_CODE
#include "Lin_MemMap.h"

extern FUNC(Std_ReturnType, LIN_PRIVATE_CODE)
    Lin_HwSendHeaderInternal(const uint8 LucChannel,
                             CONSTP2CONST(Lin_PduType, AUTOMATIC, LIN_PRIVATE_CONST) LpPduInfoPtr,
                             const uint8 LucApiId);

extern FUNC(Std_ReturnType, LIN_PRIVATE_CODE) Lin_HwInit(const uint8 LucChannel);

extern FUNC(void, LIN_PRIVATE_CODE) Lin_SetStatus(const boolean LblStatus);

#define LIN_STOP_SEC_PRIVATE_CODE
#include "Lin_MemMap.h"

#endif /* #define LIN_RLIN3_LLDRIVER_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
