/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_TAUD_Ram.h                                                                                      */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                       COPYRIGHT                                                    */
/*====================================================================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Global RAM variable definitions for PWM Driver are declared.                                                       */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.3.2: 02/08/2021 : Added the INSTANCE INDEX                                                                       **
 * 1.3.1: 02/07/2021 : Add QAC message 9.5.0                                                                          **
 *                     Format source code to 120 characters                                                           **
 *                     Improve Violation tag (remove START/END)                                                       **
 * 1.2.0: 28/07/2020 : Release                                                                                        **
 * 1.1.0: 19/06/2020 : Release                                                                                        **
 * 1.0.2: 28/05/2020 : Added Pwm_GaaTAUDChannelProp variable                                                          **
 * 1.0.1: 18/05/2020 : Removed SEC_VAR_NO_INIT_32                                                                     **
 * 1.0.0: 24/03/2020 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/

#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_TAUD_RAM_H
            #define PWM_59_INST0_TAUD_RAM_H
            #define PWM_TAUD_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_TAUD_RAM_H
            #define PWM_59_INST1_TAUD_RAM_H
            #define PWM_TAUD_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_TAUD_RAM_H
            #define PWM_59_INST2_TAUD_RAM_H
            #define PWM_TAUD_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_TAUD_RAM_H
            #define PWM_59_INST3_TAUD_RAM_H
            #define PWM_TAUD_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_TAUD_RAM_H
            #define PWM_59_INST4_TAUD_RAM_H
            #define PWM_TAUD_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_TAUD_RAM_H
            #define PWM_59_INST5_TAUD_RAM_H
            #define PWM_TAUD_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_TAUD_RAM_H
            #define PWM_59_INST6_TAUD_RAM_H
            #define PWM_TAUD_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_TAUD_RAM_H
            #define PWM_59_INST7_TAUD_RAM_H
            #define PWM_TAUD_RAM_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef PWM_TAUD_RAM_H
        #define PWM_TAUD_RAM_H
        #define PWM_TAUD_RAM_HEADER
    #endif
#endif



#ifdef PWM_TAUD_RAM_HEADER
#undef PWM_TAUD_RAM_HEADER                                                                                              /* PRQA S 0841 # JV-01 */
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/

/* AUTOSAR release version information */
#define PWM_TAUD_RAM_AR_RELEASE_MAJOR_VERSION    PWM_AR_RELEASE_MAJOR_VERSION
#define PWM_TAUD_RAM_AR_RELEASE_MINOR_VERSION    PWM_AR_RELEASE_MINOR_VERSION
#define PWM_TAUD_RAM_AR_RELEASE_REVISION_VERSION PWM_AR_RELEASE_REVISION_VERSION

/* Software module version information */
#define PWM_TAUD_RAM_SW_MAJOR_VERSION            PWM_SW_MAJOR_VERSION
#define PWM_TAUD_RAM_SW_MINOR_VERSION            PWM_SW_MINOR_VERSION
#define PWM_TAUD_RAM_SW_PATCH_VERSION            PWM_SW_PATCH_VERSION
/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (2:3684)    : Array declared with unknown size.                                                            */
/* Rule                : CERTCCM ARR02, MISRA C:2012 Rule-8.11                                                        */
/* JV-01 Justification : Arrays used are verified in the file which are only declarations and size is configuration   */
/*                       dependent.                                                                                   */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                  Global Variables                                                  **
***********************************************************************************************************************/
#if (PWM_TAUD_UNIT_USED == STD_ON)

#define PWM_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"

/* Structure for TAUD channel properties */
extern CONST(Pwm_TAUDChannelPropType, PWM_CONFIG_DATA) Pwm_GaaTAUDChannelProp[];                                        /* PRQA S 3684 # JV-01 */

#define PWM_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"

#define PWM_START_SEC_VAR_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"

/* Function pointer variable for TAUD configuration */
extern VAR(Pwm_HwFuncTableType, PWM_VAR_NO_INIT) Pwm_TaudFunc;

#define PWM_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"


#define PWM_START_SEC_VAR_NO_INIT_PTR
#include "Pwm_Mapping.h"

/* Global pointer variable for TAUD Unit configuration */
extern P2CONST(Pwm_TAUDUnitConfigType, PWM_VAR_NO_INIT, PWM_CONFIG_DATA) Pwm_GpTAUDUnitConfig;

#define PWM_STOP_SEC_VAR_NO_INIT_PTR
#include "Pwm_Mapping.h"

#endif /*#if (PWM_TAUD_UNIT_USED == STD_ON)*/
/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#endif /* PWM_TAUD_RAM_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
