/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Wdg_Version.c                                                                                       */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains code for version checking for the modules included by                                           */
/* Watchdog                                                                                                           */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.3:  10/05/2022    : Update SW-VERSION
 * 1.3.1:  05/07/2021    : Format source code to 120 characters
 *         30/06/2021    : 1) Change file name from Wdg_59_Version.c to Wdg_Version.c.
 *                         2) Correct included file.
 *                         3) Remove _VendorID ("_59") in all macros.
 * 1.2.0:  26/08/2020    : Release
 * 1.1.0:  19/06/2020    : Release
 * 1.0.0:  20/03/2020    : Initial Version
 */
/**********************************************************************************************************************/
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for module version information */
#include "Wdg.h"
/* Header file inclusion */
#include "Wdg_Version.h"

#if (WDG_DEV_ERROR_DETECT == STD_ON)
/* DET module version information is required only when DET is enabled */
#include "Det.h"
#endif
/* DEM module version information is required */
#include "Dem.h"

#if (WDG_CRITICAL_SECTION_PROTECTION == STD_ON)
/* RTE module version information is required only when critical section protection is enabled */
#include "Rte.h"
#endif

/* OS module version information is required */
#include "Os.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/

/* AUTOSAR release version information */
#define WDG_VERSION_C_AR_RELEASE_MAJOR_VERSION    WDG_AR_RELEASE_MAJOR_VERSION_VALUE
#define WDG_VERSION_C_AR_RELEASE_MINOR_VERSION    WDG_AR_RELEASE_MINOR_VERSION_VALUE
#define WDG_VERSION_C_AR_RELEASE_REVISION_VERSION WDG_AR_RELEASE_REVISION_VERSION_VALUE

/* File version information */
#define WDG_VERSION_C_SW_MAJOR_VERSION            WDG_SW_MAJOR_VERSION_VALUE
#define WDG_VERSION_C_SW_MINOR_VERSION            WDG_SW_MINOR_VERSION_VALUE

/***********************************************************************************************************************
**                                                   Version Check                                                    **
***********************************************************************************************************************/

#if (WDG_VERSION_AR_RELEASE_MAJOR_VERSION != WDG_VERSION_C_AR_RELEASE_MAJOR_VERSION)
     #error "Wdg_Version.c : Mismatch in Release Major Version"
#endif

#if (WDG_VERSION_AR_RELEASE_MINOR_VERSION != WDG_VERSION_C_AR_RELEASE_MINOR_VERSION)
     #error "Wdg_Version.c : Mismatch in Release Minor Version"
#endif

#if (WDG_VERSION_AR_RELEASE_REVISION_VERSION != WDG_VERSION_C_AR_RELEASE_REVISION_VERSION)
     #error "Wdg_Version.c : Mismatch in Release Revision Version"
#endif

#if (WDG_VERSION_SW_MAJOR_VERSION != WDG_VERSION_C_SW_MAJOR_VERSION)
     #error "Wdg_Version.c : Mismatch in Software Major Version"
#endif

#if (WDG_VERSION_SW_MINOR_VERSION != WDG_VERSION_C_SW_MINOR_VERSION)
     #error "Wdg_Version.c : Mismatch in Software Minor Version"
#endif

#if (WDG_VER_CHECK_EXT == STD_ON)

#if (WDG_DEV_ERROR_DETECT == STD_ON)

#if ((DET_AR_RELEASE_MAJOR_VERSION != WDG_AR_RELEASE_MAJOR_VERSION) || \
                                                       (DET_AR_RELEASE_MINOR_VERSION != WDG_AR_RELEASE_MINOR_VERSION))
     #error "The AR version of Det.h does not match the expected version"
#endif

#endif

#if ((DEM_AR_RELEASE_MAJOR_VERSION != WDG_AR_RELEASE_MAJOR_VERSION) || \
                                                       (DEM_AR_RELEASE_MINOR_VERSION != WDG_AR_RELEASE_MINOR_VERSION))
     #error "The AR version of Dem.h does not match the expected version"
#endif

#if (WDG_CRITICAL_SECTION_PROTECTION == STD_ON)
#if ((RTE_AR_RELEASE_MAJOR_VERSION != WDG_AR_RELEASE_MAJOR_VERSION) || \
                                                       (RTE_AR_RELEASE_MINOR_VERSION != WDG_AR_RELEASE_MINOR_VERSION))
     #error "The AR version of Rte.h does not match the expected version"
#endif
#endif

#if ((OS_AR_RELEASE_MAJOR_VERSION != WDG_AR_RELEASE_MAJOR_VERSION) || \
                                                       (OS_AR_RELEASE_MINOR_VERSION != WDG_AR_RELEASE_MINOR_VERSION))
     #error "The AR version of Os.h does not match the expected version"
#endif

#endif /* #if (WDG_VER_CHECK_EXT == STD_ON) */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
